/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.joyqueue.toolkit.time.SystemClock;

public class Locks {
    public static final int LOCK_FAIL = -2;

    public static long tryLock(Lock lock, long timeout) {
        if (timeout > 0L) {
            long time = SystemClock.now();
            try {
                if (lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    time = timeout - (SystemClock.now() - time);
                    if (time > 0L) {
                        return time;
                    }
                    lock.unlock();
                }
                return -2L;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return -2L;
            }
        }
        lock.lock();
        return timeout == 0L ? 0L : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean awaitQuiet(Lock lock, Condition condition, long timeout, Callable<Boolean> doubleCheck) {
        boolean locked = false;
        try {
            if (timeout > 0L) {
                long time = SystemClock.now();
                if (lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    locked = true;
                    time = timeout - (SystemClock.now() - time);
                    if (time > 0L) {
                        if (doubleCheck == null || !doubleCheck.call().booleanValue()) {
                            condition.await(time, TimeUnit.MILLISECONDS);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            lock.lock();
            locked = true;
            condition.await();
            boolean time = true;
            return time;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    public static boolean awaitQuiet(Condition condition, long time) {
        if (condition == null) {
            return false;
        }
        try {
            condition.await(time, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static boolean awaitQuiet(Condition condition) {
        if (condition == null) {
            return false;
        }
        try {
            condition.await();
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void await(Object mutex) throws InterruptedException {
        if (mutex == null) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            mutex.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean awaitQuiet(Object mutex) {
        if (mutex == null) {
            return false;
        }
        Object object = mutex;
        synchronized (object) {
            try {
                mutex.wait();
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void await(Object mutex, long time) throws InterruptedException {
        if (mutex == null) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            mutex.wait(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean awaitQuiet(Object mutex, long time) {
        if (mutex == null) {
            return false;
        }
        Object object = mutex;
        synchronized (object) {
            try {
                mutex.wait(time);
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    public static void signalAll(Lock lock, Condition condition) {
        lock.lock();
        try {
            condition.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signalAll(Lock lock, Condition ... conditions) {
        lock.lock();
        try {
            for (Condition condition : conditions) {
                condition.signalAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notify(Object mutex) {
        if (mutex == null) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAll(Object mutex) {
        if (mutex == null) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            mutex.notifyAll();
        }
    }
}

