/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.concurrent;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joyqueue.toolkit.lang.LifeCycle;

public abstract class LoopThread
implements Runnable,
LifeCycle {
    private Thread thread = null;
    private String name;
    protected long minSleep = 50L;
    protected long maxSleep = 500L;
    private boolean daemon;
    private final Lock wakeupLock = new ReentrantLock();
    private final java.util.concurrent.locks.Condition wakeupCondition = this.wakeupLock.newCondition();
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_STARTING = 2;
    private static final int STATE_RUNNING = 3;
    private AtomicInteger state = new AtomicInteger(0);
    private AtomicBoolean needToWakeUp = new AtomicBoolean(false);

    abstract void doWork() throws Throwable;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    protected boolean condition() {
        return true;
    }

    @Override
    public synchronized void start() {
        if (!this.isStarted()) {
            this.state.set(2);
            this.thread = new Thread(this);
            this.thread.setName(this.name == null ? "LoopThread" : this.name);
            this.thread.setDaemon(this.daemon);
            this.thread.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.state.get() != 0) {
            this.state.set(1);
            this.thread.interrupt();
            while (this.state.get() != 0) {
                try {
                    this.wakeup();
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.state.get() == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.state.compareAndSet(2, 3)) {
            while (this.state.get() == 3) {
                long t0 = System.nanoTime();
                try {
                    if (this.condition()) {
                        this.doWork();
                    }
                }
                catch (InterruptedException i) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    if (!this.handleException(t)) break;
                }
                try {
                    long t1 = System.nanoTime();
                    if (t1 - t0 >= this.minSleep * 1000000L) continue;
                    this.wakeupLock.lock();
                    try {
                        this.needToWakeUp.set(true);
                        this.wakeupCondition.await(this.minSleep < this.maxSleep ? ThreadLocalRandom.current().nextLong(this.minSleep, this.maxSleep) : this.minSleep, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        this.wakeupLock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.state.set(0);
    }

    public synchronized void wakeup() {
        if (this.needToWakeUp.compareAndSet(true, false)) {
            this.wakeupLock.lock();
            try {
                this.wakeupCondition.signal();
            }
            finally {
                this.wakeupLock.unlock();
            }
        }
    }

    protected boolean handleException(Throwable t) {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private long minSleep = -1L;
        private long maxSleep = -1L;
        private Boolean daemon;
        private Worker worker;
        private ExceptionHandler exceptionHandler;
        private ExceptionListener exceptionListener;
        private Condition condition;

        public Builder doWork(Worker worker) {
            this.worker = worker;
            return this;
        }

        public Builder handleException(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public Builder onException(ExceptionListener exceptionListener) {
            this.exceptionListener = exceptionListener;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sleepTime(long minSleep, long maxSleep) {
            this.minSleep = minSleep;
            this.maxSleep = maxSleep;
            return this;
        }

        public Builder daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public LoopThread build() {
            LoopThread loopThread = new LoopThread(){

                @Override
                void doWork() throws Throwable {
                    worker.doWork();
                }

                @Override
                protected boolean handleException(Throwable t) {
                    if (null != exceptionListener) {
                        exceptionListener.onException(t);
                    }
                    if (null != exceptionHandler) {
                        return exceptionHandler.handleException(t);
                    }
                    return super.handleException(t);
                }

                @Override
                protected boolean condition() {
                    if (null != condition) {
                        return condition.condition();
                    }
                    return super.condition();
                }
            };
            if (null != this.name) {
                loopThread.setName(this.name);
            }
            if (null != this.daemon) {
                loopThread.setDaemon(this.daemon);
            }
            if (this.minSleep >= 0L) {
                loopThread.minSleep = this.minSleep;
            }
            if (this.maxSleep >= 0L) {
                loopThread.maxSleep = this.maxSleep;
            }
            return loopThread;
        }
    }

    public static interface Condition {
        public boolean condition();
    }

    public static interface ExceptionListener {
        public void onException(Throwable var1);
    }

    public static interface ExceptionHandler {
        public boolean handleException(Throwable var1);
    }

    public static interface Worker {
        public void doWork() throws Throwable;
    }
}

