/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.joyqueue.toolkit.config.Binder;
import org.joyqueue.toolkit.config.Binders;
import org.joyqueue.toolkit.config.Context;
import org.joyqueue.toolkit.config.annotation.Binding;
import org.joyqueue.toolkit.reflect.Reflect;
import org.joyqueue.toolkit.reflect.ReflectException;

public class BindingBinder
implements Binder {
    public static final BindingBinder INSTANCE = new BindingBinder();

    @Override
    public void bind(Field field, Annotation annotation, Object target, Context context) throws ReflectException {
        if (field == null || annotation == null || target == null || context == null || !(annotation instanceof Binding)) {
            return;
        }
        Class<?> type = field.getType();
        if (!this.isSupported(type)) {
            return;
        }
        Object value = Reflect.get(field, target);
        if (type.isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object obj = Array.get(value, i);
                if (obj == null || !this.isSupported(obj.getClass())) continue;
                Binders.bind(context, obj);
            }
        } else if (Collection.class.isAssignableFrom(type)) {
            for (Object obj : (Collection)value) {
                if (obj == null || !this.isSupported(obj.getClass())) continue;
                Binders.bind(context, obj);
            }
        } else {
            Binders.bind(context, value);
        }
    }

    protected boolean isSupported(Class type) {
        if (type == Integer.TYPE) {
            return false;
        }
        if (type == Long.TYPE) {
            return false;
        }
        if (type == Double.TYPE) {
            return false;
        }
        if (type == Short.TYPE) {
            return false;
        }
        if (type == Byte.TYPE) {
            return false;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (Number.class.isAssignableFrom(type)) {
            return false;
        }
        if (type == Boolean.class) {
            return false;
        }
        if (type == String.class) {
            return false;
        }
        if (type == Object.class) {
            return false;
        }
        if (Date.class.isAssignableFrom(type)) {
            return false;
        }
        return !Map.class.isAssignableFrom(type);
    }
}

