/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

public interface ContextKey {
    public static final String JOB_SUFFIX = "Job";
    public static final String SERVICE_SUFFIX = "Service";
    public static final String INTERVAL_SUFFIX = ".interval";
    public static final String CRON_SUFFIX = ".cron";

    public String getKey();

    public static class CronJobKey
    extends JobKey {
        public CronJobKey(String name) {
            super(name, ContextKey.CRON_SUFFIX);
        }
    }

    public static class IntervalJobKey
    extends JobKey {
        public IntervalJobKey(String name) {
            super(name, ContextKey.INTERVAL_SUFFIX);
        }
    }

    public static class JobKey
    extends ConfigKey {
        public JobKey(String className, String suffix) {
            char[] chars;
            if (className == null || className.isEmpty()) {
                throw new IllegalArgumentException("className can not be empty.");
            }
            if (className.endsWith(ContextKey.JOB_SUFFIX)) {
                className = className.substring(0, className.length() - ContextKey.JOB_SUFFIX.length());
            } else if (className.endsWith(ContextKey.SERVICE_SUFFIX)) {
                className = className.substring(0, className.length() - ContextKey.SERVICE_SUFFIX.length());
            }
            int count = 0;
            StringBuilder builder = new StringBuilder();
            for (char ch : chars = className.toCharArray()) {
                ++count;
                if (Character.isUpperCase(ch)) {
                    if (count > 1) {
                        builder.append('.');
                    }
                    builder.append(Character.toLowerCase(ch));
                    continue;
                }
                builder.append(ch);
            }
            if (suffix != null) {
                builder.append(suffix);
            }
            this.key = builder.toString();
        }
    }

    public static class ConfigKey
    implements ContextKey {
        protected String key;

        public ConfigKey() {
        }

        public ConfigKey(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

