/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.joyqueue.toolkit.config.Binder;
import org.joyqueue.toolkit.config.Context;
import org.joyqueue.toolkit.config.annotation.DoubleBinding;
import org.joyqueue.toolkit.reflect.Reflect;
import org.joyqueue.toolkit.reflect.ReflectException;
import org.joyqueue.toolkit.validate.annotation.DoubleRange;

public class DoubleBinder
implements Binder {
    public static final DoubleBinder INSTANCE = new DoubleBinder();

    @Override
    public void bind(Field field, Annotation annotation, Object target, Context context) throws ReflectException {
        if (field == null || annotation == null || target == null || context == null || !(annotation instanceof DoubleBinding)) {
            return;
        }
        DoubleBinding binding = (DoubleBinding)annotation;
        Class<Double> type = field.getType();
        if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
            double value = context.getDouble(binding.key(), binding.defaultValue());
            DoubleRange range = binding.range();
            if (range != null && (value < range.min() || value > range.max())) {
                value = binding.defaultValue();
            }
            Reflect.set(field, target, value);
        }
    }
}

