/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.joyqueue.toolkit.config.Binder;
import org.joyqueue.toolkit.config.Context;
import org.joyqueue.toolkit.config.annotation.NumberBinding;
import org.joyqueue.toolkit.reflect.Reflect;
import org.joyqueue.toolkit.reflect.ReflectException;
import org.joyqueue.toolkit.validate.annotation.Range;

public class NumberBinder
implements Binder {
    public static final NumberBinder INSTANCE = new NumberBinder();

    @Override
    public void bind(Field field, Annotation annotation, Object target, Context context) throws ReflectException {
        if (field == null || annotation == null || target == null || context == null || !(annotation instanceof NumberBinding)) {
            return;
        }
        NumberBinding binding = (NumberBinding)annotation;
        Class<Number> type = field.getType();
        Number number = null;
        Range range = binding.range();
        if (type.isAssignableFrom(Byte.TYPE) || type.isAssignableFrom(Byte.class)) {
            number = context.getByte(binding.key(), (byte)binding.defaultValue());
            number = range != null && (number.longValue() < range.min() || number.longValue() > range.max()) ? (Number)((byte)binding.defaultValue()) : (Number)number;
            Reflect.set(field, target, number);
        } else if (type.isAssignableFrom(Short.TYPE) || type.isAssignableFrom(Short.class)) {
            number = context.getShort(binding.key(), (short)binding.defaultValue());
            number = range != null && (number.longValue() < range.min() || number.longValue() > range.max()) ? (Number)((short)binding.defaultValue()) : (Number)number;
            Reflect.set(field, target, number);
        } else if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
            number = context.getInteger(binding.key(), (int)binding.defaultValue());
            number = range != null && (number.longValue() < range.min() || number.longValue() > range.max()) ? (Number)((int)binding.defaultValue()) : (Number)number;
            Reflect.set(field, target, number);
        } else if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
            number = context.getLong(binding.key(), binding.defaultValue());
            number = range != null && (number.longValue() < range.min() || number.longValue() > range.max()) ? (Number)binding.defaultValue() : (Number)number;
            Reflect.set(field, target, number);
        }
    }
}

