/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joyqueue.toolkit.config.Context;
import org.joyqueue.toolkit.config.Postman;
import org.joyqueue.toolkit.lang.Pair;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.service.ServiceThread;
import org.joyqueue.toolkit.validate.annotation.Size;
import org.joyqueue.toolkit.validate.annotation.Valid;

@Valid
public abstract class PostmanUpdater
extends Service
implements Postman {
    @Size
    protected int interval;
    protected Thread worker;
    protected ConcurrentMap<String, Pair<String, Context>> caches = new ConcurrentHashMap<String, Pair<String, Context>>();
    protected ConcurrentMap<String, List<Postman.GroupListener>> listeners = new ConcurrentHashMap<String, List<Postman.GroupListener>>();

    public void setInterval(int interval) {
        this.interval = interval;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (!this.listeners.isEmpty()) {
            this.update();
        }
        this.worker = new Thread((Runnable)new Worker(this, (long)this.interval), this.getClass().getSimpleName());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    @Override
    protected void doStop() {
        if (this.worker != null && !this.worker.isInterrupted()) {
            this.worker.interrupt();
        }
        this.caches.clear();
        super.doStop();
    }

    @Override
    public void addListener(String group, Postman.GroupListener listener) {
        Context context;
        List old;
        if (group == null || group.isEmpty() || listener == null) {
            return;
        }
        List<Postman.GroupListener> grpListeners = (CopyOnWriteArrayList<Postman.GroupListener>)this.listeners.get(group);
        if (grpListeners == null && (old = (List)this.listeners.putIfAbsent(group, grpListeners = new CopyOnWriteArrayList<Postman.GroupListener>())) != null) {
            grpListeners = old;
        }
        if (this.isStarted() && (context = this.getOrUpdate(group)) != null) {
            this.publish(group, listener, context.clone());
        }
        grpListeners.add(listener);
    }

    @Override
    public void removeListener(String group, Postman.GroupListener listener) {
        if (group == null || group.isEmpty() || listener == null) {
            return;
        }
        List grpListeners = (List)this.listeners.get(group);
        if (grpListeners != null) {
            grpListeners.remove(listener);
        }
    }

    @Override
    public Context get(String group) {
        if (!this.isStarted()) {
            throw new IllegalStateException("service is not started.");
        }
        return this.getOrUpdate(group);
    }

    protected Context getOrUpdate(String group) {
        Pair<String, Context> pair = (Pair<String, Context>)this.caches.get(group);
        if (pair == null) {
            Context context = this.update(group);
            pair = new Pair<String, Context>(group, context);
            Pair<String, Context> old = this.caches.putIfAbsent(group, pair);
            if (context == null && old != null && old.getValue() != null) {
                pair = old;
            }
        }
        return (Context)pair.getValue();
    }

    protected void update() {
        for (Map.Entry entry : this.listeners.entrySet()) {
            if (!this.isStarted()) {
                return;
            }
            String group = (String)entry.getKey();
            Context context = this.update(group);
            Pair pair = (Pair)this.caches.get(group);
            if (context == null || pair == null || context.equals(pair.getValue())) continue;
            this.caches.put(group, new Pair<String, Context>(group, context));
            for (Postman.GroupListener listener : (List)entry.getValue()) {
                if (!this.isStarted()) {
                    return;
                }
                this.publish(group, listener, context.clone());
            }
        }
    }

    protected abstract Context update(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish(String group, Postman.GroupListener listener, Context context) {
        Postman.GroupListener groupListener = listener;
        synchronized (groupListener) {
            listener.onUpdate(group, context);
        }
    }

    protected class Worker
    extends ServiceThread {
        public Worker(Service parent, long interval) {
            super(parent, interval);
        }

        @Override
        protected void execute() throws Exception {
            PostmanUpdater.this.update();
        }

        @Override
        public boolean onException(Throwable e) {
            return true;
        }
    }
}

