/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

import com.jd.laf.extension.Converts;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Property {
    public static final String CPU_CORES = "host.cpucores";
    public static final String MEMORY = "host.memory";
    public static final String DISK_SIZE = "host.disksize";
    public static final String DATA_CENTER = "host.datacenter";
    public static final String SYSTEM_NAME = "system.name";
    public static final String APPLICATION_NAME = "application.name";
    public static final String APPLICATION_DEPLOY_NAME = "application.deploy.name";
    public static final String APPLICATION_ID = "application.id";
    public static final String APPLICATION_GROUP = "application.group";
    public static final String CLIENT_VERSION = "client.version";
    public static final String USER_HOME = "user.home";
    public static final String JAVA_IO_TEMPDIR = "java.io.tmpdir";
    public static final String OS_NAME = "os.name";
    public static final String OS_TYPE = "os.type";
    public static final String PID = "pid";
    public static final String JAVA_VERSION = "java.version";
    public static final String APPLICATION_DATA_PATH = "application.data.path";
    public static final String AUTO_LISTENER = "autoListener";
    protected String name;
    protected String key;
    protected Object value;
    protected long version;
    protected int priority;

    public Property() {
    }

    public Property(String key) {
        this.key = key;
    }

    public Property(String name, String key, Object value) {
        this(name, key, value, 0L, 0);
    }

    public Property(String name, String key, Object value, long version, int priority) {
        this.name = name;
        this.key = key;
        this.value = value;
        this.version = version;
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public long getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getString() {
        return Converts.getString((Object)this.value);
    }

    public String getString(String def) {
        return Converts.getString((Object)this.value, (String)def);
    }

    public Date getDate(Date def) {
        return Converts.getDate((Object)this.value, (Date)def);
    }

    public Date getDate(SimpleDateFormat format) {
        return Converts.getDate((Object)this.value, (SimpleDateFormat)format, null);
    }

    public Date getDate(SimpleDateFormat format, Date def) {
        return Converts.getDate((Object)this.value, (SimpleDateFormat)format, (Date)def);
    }

    public Float getFloat() {
        return Converts.getFloat((Object)this.value, null);
    }

    public Float getFloat(Float def) {
        return Converts.getFloat((Object)this.value, (Float)def);
    }

    public Double getDouble() {
        return Converts.getDouble((Object)this.value, null);
    }

    public Double getDouble(Double def) {
        return Converts.getDouble((Object)this.value, (Double)def);
    }

    public Long getLong() {
        return Converts.getLong((Object)this.value, null);
    }

    public Long getLong(Long def) {
        return Converts.getLong((Object)this.value, (Long)def);
    }

    public Integer getInteger() {
        return Converts.getInteger((Object)this.value, null);
    }

    public Integer getInteger(Integer def) {
        return Converts.getInteger((Object)this.value, (Integer)def);
    }

    public Short getShort() {
        return Converts.getShort((Object)this.value, null);
    }

    public Short getShort(Short def) {
        return Converts.getShort((Object)this.value, (Short)def);
    }

    public Byte getByte() {
        return Converts.getByte((Object)this.value, null);
    }

    public Byte getByte(Byte def) {
        return Converts.getByte((Object)this.value, (Byte)def);
    }

    public Boolean getBoolean() {
        return Converts.getBoolean((Object)this.value, null);
    }

    public Boolean getBoolean(Boolean def) {
        return Converts.getBoolean((Object)this.value, (Boolean)def);
    }

    public Long getNatural(Long def) {
        return Converts.getNatural((Object)this.value, (Long)def);
    }

    public Integer getNatural(Integer def) {
        return Converts.getNatural((Object)this.value, (Integer)def);
    }

    public Short getNatural(Short def) {
        return Converts.getNatural((Object)this.value, (Short)def);
    }

    public Byte getNatural(Byte def) {
        return Converts.getNatural((Object)this.value, (Byte)def);
    }

    public Long getPositive(Long def) {
        return Converts.getPositive((Object)this.value, (Long)def);
    }

    public Integer getPositive(Integer def) {
        return Converts.getPositive((Object)this.value, (Integer)def);
    }

    public Short getPositive(Short def) {
        return Converts.getPositive((Object)this.value, (Short)def);
    }

    public Byte getPositive(Byte def) {
        return Converts.getPositive((Object)this.value, (Byte)def);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        if (this.name != null ? !this.name.equals(property.name) : property.name != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(property.key) : property.key != null) {
            return false;
        }
        return this.value != null ? this.value.equals(property.value) : property.value == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Property{name='" + this.name + '\'' + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static enum Type {
        BOOLEAN,
        STRING,
        INT,
        SHORT,
        LONG,
        DOUBLE,
        OBJECT;

    }
}

