/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

import com.jd.laf.extension.Converts;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;

public interface PropertySupplier {
    public Property getOrCreateProperty(String var1);

    public Property getProperty(String var1);

    public List<Property> getProperties();

    public List<Property> getPrefix(String var1);

    default public <T> T getValue(PropertyDef key) {
        return PropertySupplier.getValue(this, key);
    }

    public static <T> T getValue(PropertySupplier supplier, PropertyDef key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        return PropertySupplier.getValue(supplier, key.getName(), key.getType(), key.getValue());
    }

    public static <T> T getValue(PropertySupplier supplier, String key, PropertyDef.Type type, Object defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        Property property = supplier.getProperty(key);
        Object value = property != null ? property.getValue() : defaultValue;
        switch (type) {
            case BOOLEAN: {
                return (T)Converts.getBoolean((Object)value, (Boolean)Converts.getBoolean((Object)defaultValue));
            }
            case STRING: {
                return (T)Converts.getString((Object)value, (String)Converts.getString((Object)defaultValue));
            }
            case INT: {
                return (T)Converts.getInteger((Object)value, (Integer)Converts.getInteger((Object)defaultValue));
            }
            case SHORT: {
                return (T)Converts.getShort((Object)value, (Short)Converts.getShort((Object)defaultValue));
            }
            case LONG: {
                return (T)Converts.getLong((Object)value, (Long)Converts.getLong((Object)defaultValue));
            }
            case DOUBLE: {
                return (T)Converts.getDouble((Object)value, (Double)Converts.getDouble((Object)defaultValue));
            }
        }
        return (T)(value == null ? defaultValue : value);
    }

    public static <T> T getValue(PropertySupplier supplier, PropertyDef key, Object value) {
        Property property;
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        Object propertyValue = null;
        if (null != supplier && (property = supplier.getProperty(key.getName())) != null) {
            propertyValue = property.getValue();
        }
        Object defaultValue = key.getValue();
        switch (key.getType()) {
            case BOOLEAN: {
                return (T)Converts.getBoolean((Object)propertyValue, (Boolean)Converts.getBoolean((Object)value, (Boolean)Converts.getBoolean((Object)defaultValue)));
            }
            case STRING: {
                return (T)Converts.getString((Object)propertyValue, (String)Converts.getString((Object)value, (String)Converts.getString((Object)defaultValue)));
            }
            case INT: {
                return (T)Converts.getInteger((Object)propertyValue, (Integer)Converts.getInteger((Object)value, (Integer)Converts.getInteger((Object)defaultValue)));
            }
            case SHORT: {
                return (T)Converts.getShort((Object)propertyValue, (Short)Converts.getShort((Object)value, (Short)Converts.getShort((Object)defaultValue)));
            }
            case LONG: {
                return (T)Converts.getLong((Object)propertyValue, (Long)Converts.getLong((Object)value, (Long)Converts.getLong((Object)defaultValue)));
            }
            case DOUBLE: {
                return (T)Converts.getDouble((Object)propertyValue, (Double)Converts.getDouble((Object)value, (Double)Converts.getDouble((Object)defaultValue)));
            }
        }
        return (T)(propertyValue == null ? (value == null ? defaultValue : value) : propertyValue);
    }

    public static class MapSupplier
    implements PropertySupplier {
        Map<String, Object> map;

        public MapSupplier(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public Property getOrCreateProperty(String key) {
            if (key == null) {
                return null;
            }
            Property result = this.getProperty(key);
            return result == null ? new Property(null, key, null) : result;
        }

        @Override
        public Property getProperty(String key) {
            if (key == null) {
                return null;
            }
            Object value = this.map == null ? null : this.map.get(key);
            return value == null ? null : new Property(null, key, value.toString());
        }

        @Override
        public List<Property> getProperties() {
            ArrayList<Property> result = new ArrayList<Property>(this.map == null ? 0 : this.map.size());
            if (this.map == null) {
                return result;
            }
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                result.add(new Property(null, entry.getKey(), entry.getValue()));
            }
            return result;
        }

        @Override
        public List<Property> getPrefix(String prefix) {
            ArrayList<Property> result = new ArrayList<Property>();
            if (prefix == null || prefix.isEmpty() || this.map == null) {
                return result;
            }
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                result.add(new Property(null, entry.getKey(), entry.getValue()));
            }
            return result;
        }
    }
}

