/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.sql.DataSource;

public class DaoUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int insert(DataSource dataSource, List<T> targets, String sql, UpdateCallback<T> callback) throws Exception {
        if (targets == null || targets.isEmpty()) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(false);
            int count = DaoUtil.insert(connection, targets, sql, callback);
            connection.commit();
            int n = count;
            return n;
        }
        finally {
            DaoUtil.close(connection, null, null);
        }
    }

    public static <T> int insert(Connection connection, List<T> targets, String sql, UpdateCallback<T> callback) throws Exception {
        int n;
        if (targets == null || targets.isEmpty()) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection can not be null.");
        }
        PreparedStatement statement = null;
        ResultSet rs = null;
        InsertCallback insertCallback = null;
        if (callback instanceof InsertCallback) {
            insertCallback = (InsertCallback)callback;
        }
        try {
            statement = connection.prepareStatement(sql, insertCallback == null ? 2 : 1);
            int count = 0;
            for (T target : targets) {
                if (target == null) continue;
                callback.before(statement, target);
                count += statement.executeUpdate();
                if (insertCallback == null) continue;
                rs = statement.getGeneratedKeys();
                if (rs.next()) {
                    insertCallback.after(rs, target);
                }
                rs.close();
                rs = null;
            }
            n = count;
        }
        catch (Exception e) {
            try {
                DaoUtil.rollback(connection);
                throw e;
            }
            catch (Throwable throwable) {
                DaoUtil.close(null, statement, rs);
                throw throwable;
            }
        }
        DaoUtil.close(null, statement, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int insert(DataSource dataSource, T target, String sql, UpdateCallback<T> callback) throws Exception {
        if (target == null) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(true);
            int n = DaoUtil.insert(connection, target, sql, callback);
            return n;
        }
        finally {
            DaoUtil.close(connection, null, null);
        }
    }

    public static <T> int insert(Connection connection, T target, String sql, UpdateCallback<T> callback) throws Exception {
        int n;
        if (target == null) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection can not be null.");
        }
        PreparedStatement statement = null;
        ResultSet rs = null;
        InsertCallback insertCallback = null;
        if (callback instanceof InsertCallback) {
            insertCallback = (InsertCallback)callback;
        }
        try {
            statement = connection.prepareStatement(sql, insertCallback == null ? 2 : 1);
            callback.before(statement, target);
            int count = statement.executeUpdate();
            if (insertCallback != null && (rs = statement.getGeneratedKeys()).next()) {
                insertCallback.after(rs, target);
            }
            n = count;
        }
        catch (Exception e) {
            try {
                DaoUtil.rollback(connection);
                throw e;
            }
            catch (Throwable throwable) {
                DaoUtil.close(null, statement, rs);
                throw throwable;
            }
        }
        DaoUtil.close(null, statement, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int update(DataSource dataSource, T target, String sql, UpdateCallback<T> callback) throws Exception {
        if (target == null) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(true);
            int n = DaoUtil.update(connection, target, sql, callback);
            return n;
        }
        finally {
            DaoUtil.close(connection, null, null);
        }
    }

    public static <T> int update(Connection connection, T target, String sql, UpdateCallback<T> callback) throws Exception {
        if (target == null) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection can not be null.");
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            callback.before(statement, target);
            int n = statement.executeUpdate();
            return n;
        }
        catch (Exception e) {
            DaoUtil.rollback(connection);
            throw e;
        }
        finally {
            DaoUtil.close(null, statement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int update(DataSource dataSource, List<T> targets, String sql, UpdateCallback<T> callback) throws Exception {
        if (targets == null || targets.isEmpty()) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(false);
            int count = DaoUtil.update(connection, targets, sql, callback);
            connection.commit();
            int n = count;
            return n;
        }
        finally {
            DaoUtil.close(connection, null, null);
        }
    }

    public static <T> int update(Connection connection, List<T> targets, String sql, UpdateCallback<T> callback) throws Exception {
        if (targets == null || targets.isEmpty()) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection can not be null.");
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            int count = 0;
            for (T target : targets) {
                if (target == null) continue;
                callback.before(statement, target);
                count += statement.executeUpdate();
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            DaoUtil.rollback(connection);
            throw e;
        }
        finally {
            DaoUtil.close(null, statement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int delete(DataSource dataSource, T target, String sql, UpdateCallback<T> callback) throws Exception {
        if (target == null) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(true);
            int n = DaoUtil.delete(connection, target, sql, callback);
            return n;
        }
        finally {
            DaoUtil.close(connection, null, null);
        }
    }

    public static <T> int delete(Connection connection, T target, String sql, UpdateCallback<T> callback) throws Exception {
        if (target == null) {
            return 0;
        }
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection can not be null.");
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            callback.before(statement, target);
            int n = statement.executeUpdate();
            return n;
        }
        catch (Exception e) {
            DaoUtil.rollback(connection);
            throw e;
        }
        finally {
            DaoUtil.close(null, statement, null);
        }
    }

    protected static void rollback(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.getAutoCommit()) {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(DataSource dataSource, String sql, StatementCallback callback) throws Exception {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(true);
            int n = DaoUtil.execute(connection, sql, callback);
            return n;
        }
        finally {
            DaoUtil.close(connection, null, null);
        }
    }

    public static int execute(Connection connection, String sql, StatementCallback callback) throws Exception {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("sql can not be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null.");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection can not be null.");
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            callback.before(statement);
            int n = statement.executeUpdate();
            return n;
        }
        catch (Exception e) {
            DaoUtil.rollback(connection);
            throw e;
        }
        finally {
            DaoUtil.close(null, statement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T queryObject(DataSource dataSource, String sql, QueryCallback<T> callback) throws Exception {
        ResultSet rs;
        PreparedStatement statement;
        Connection connection;
        block4: {
            T t;
            if (dataSource == null || sql == null || sql.isEmpty() || callback == null) {
                return null;
            }
            connection = null;
            statement = null;
            rs = null;
            try {
                connection = dataSource.getConnection();
                statement = connection.prepareStatement(sql);
                callback.before(statement);
                rs = statement.executeQuery();
                if (rs.next()) break block4;
                t = null;
            }
            catch (Throwable throwable) {
                DaoUtil.close(connection, statement, rs);
                throw throwable;
            }
            DaoUtil.close(connection, statement, rs);
            return t;
        }
        T t = callback.map(rs);
        DaoUtil.close(connection, statement, rs);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T queryObject(DBConfig dbConfig, String sql, QueryCallback<T> callback) throws Exception {
        ResultSet rs;
        PreparedStatement statement;
        Connection connection;
        block4: {
            T t;
            if (dbConfig == null || sql == null || sql.isEmpty() || callback == null) {
                return null;
            }
            connection = null;
            statement = null;
            rs = null;
            try {
                connection = DriverManager.getConnection(dbConfig.jdbcUrl(), dbConfig.getUsername(), dbConfig.getPassword());
                statement = connection.prepareStatement(sql);
                callback.before(statement);
                rs = statement.executeQuery();
                if (rs.next()) break block4;
                t = null;
            }
            catch (Throwable throwable) {
                DaoUtil.close(connection, statement, rs);
                throw throwable;
            }
            DaoUtil.close(connection, statement, rs);
            return t;
        }
        T t = callback.map(rs);
        DaoUtil.close(connection, statement, rs);
        return t;
    }

    public static void close(Connection connection, Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> queryList(DataSource dataSource, String sql, QueryCallback<T> callback) throws Exception {
        ArrayList<T> arrayList;
        ArrayList<T> result = new ArrayList<T>();
        if (dataSource == null || sql == null || sql.isEmpty() || callback == null) {
            return result;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            statement = connection.prepareStatement(sql);
            callback.before(statement);
            rs = statement.executeQuery();
            while (rs.next()) {
                result.add(callback.map(rs));
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DaoUtil.close(connection, statement, rs);
            throw throwable;
        }
        DaoUtil.close(connection, statement, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> queryList(DBConfig dbConfig, String sql, QueryCallback<T> callback) throws Exception {
        ArrayList<T> arrayList;
        ArrayList<T> result = new ArrayList<T>();
        if (dbConfig == null || sql == null || sql.isEmpty() || callback == null) {
            return result;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = DriverManager.getConnection(dbConfig.jdbcUrl(), dbConfig.getUsername(), dbConfig.getPassword());
            statement = connection.prepareStatement(sql);
            callback.before(statement);
            rs = statement.executeQuery();
            while (rs.next()) {
                result.add(callback.map(rs));
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DaoUtil.close(connection, statement, rs);
            throw throwable;
        }
        DaoUtil.close(connection, statement, rs);
        return arrayList;
    }

    public static class DBConfig {
        private String driverClassName;
        private String url;
        private String username;
        private String password;
        private String connectionProperties;

        public DBConfig() {
        }

        public DBConfig(String driverClassName, String url, String username, String password, String connectionProperties) {
            this.driverClassName = driverClassName;
            this.url = url;
            this.username = username;
            this.password = password;
            this.connectionProperties = connectionProperties;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public void setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getConnectionProperties() {
            return this.connectionProperties;
        }

        public void setConnectionProperties(String connectionProperties) {
            this.connectionProperties = connectionProperties;
        }

        public String jdbcUrl() {
            if (this.url == null || this.url.isEmpty()) {
                return null;
            }
            if (this.connectionProperties == null || this.connectionProperties.isEmpty()) {
                return this.url;
            }
            int pos = this.url.indexOf(63);
            StringBuilder sb = new StringBuilder(100);
            sb.append(this.url.trim());
            int count = 0;
            StringTokenizer tokenizer = new StringTokenizer(this.connectionProperties.trim(), ";");
            while (tokenizer.hasMoreTokens()) {
                sb.append((char)(count++ == 0 && pos == -1 ? 63 : 38)).append(tokenizer.nextToken());
            }
            return sb.toString();
        }
    }

    public static interface QueryCallback<T>
    extends StatementCallback {
        public T map(ResultSet var1) throws Exception;
    }

    public static interface InsertCallback<T>
    extends UpdateCallback<T> {
        public void after(ResultSet var1, T var2) throws Exception;
    }

    public static interface UpdateCallback<T> {
        public void before(PreparedStatement var1, T var2) throws Exception;
    }

    public static interface StatementCallback {
        public void before(PreparedStatement var1) throws Exception;
    }
}

