/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.delay;

import java.util.concurrent.atomic.AtomicBoolean;
import org.joyqueue.toolkit.delay.TimerTask;
import org.joyqueue.toolkit.time.SystemClock;

public abstract class DelayedOperation
extends TimerTask {
    private AtomicBoolean completed = new AtomicBoolean(false);

    public DelayedOperation(long delayMs) {
        this.delayMs = delayMs + SystemClock.now();
    }

    public boolean forceComplete() {
        if (this.completed.compareAndSet(false, true)) {
            this.cancel();
            this.onComplete();
            return true;
        }
        return false;
    }

    protected boolean isCompleted() {
        return this.completed.get();
    }

    protected abstract void onExpiration();

    protected abstract void onComplete();

    protected abstract boolean tryComplete();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean safeTryComplete() {
        DelayedOperation delayedOperation = this;
        synchronized (delayedOperation) {
            return this.tryComplete();
        }
    }

    @Override
    public void run() {
        if (this.forceComplete()) {
            this.onExpiration();
        }
    }
}

