/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.delay;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.delay.DelayedOperation;
import org.joyqueue.toolkit.delay.Timer;
import org.joyqueue.toolkit.delay.TimerTask;

public class DelayedOperationManager<T extends DelayedOperation> {
    private Timer timeoutTimer;
    private String purgatoryName;
    private int purgeInterval = 1000;
    private int watchers = 512;
    private ExecutorService taskExecutor;
    private List<WatchersList> watchersList;
    private AtomicInteger estimatedTotalOperations = new AtomicInteger(0);
    private ExpiredOperationReaper expirationReaper;

    public DelayedOperationManager(String purgatoryName) {
        this(purgatoryName, 1000, true);
    }

    public DelayedOperationManager(final String purgatoryName, int purgeInterval, boolean reaperEnable) {
        this.taskExecutor = Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                NamedThreadFactory threadFactory = new NamedThreadFactory("joyqueue-delayed-operation-executor-" + purgatoryName);
                Thread thread = threadFactory.newThread(r);
                return thread;
            }
        });
        this.purgatoryName = purgatoryName;
        this.timeoutTimer = new Timer(this.taskExecutor);
        this.purgeInterval = purgeInterval;
        this.watchersList = this.initWatchersList();
    }

    public void start() {
        this.expirationReaper = new ExpiredOperationReaper(String.format("ExpirationReaper-%s", this.purgatoryName));
        this.expirationReaper.start();
    }

    public void shutdown() {
        if (this.expirationReaper != null) {
            this.expirationReaper.shutdown();
        }
        if (this.taskExecutor != null) {
            this.taskExecutor.shutdown();
        }
    }

    protected List<WatchersList> initWatchersList() {
        ArrayList watchersList = Lists.newArrayListWithCapacity((int)this.watchers);
        for (int i = 0; i < this.watchers; ++i) {
            watchersList.add(new WatchersList());
        }
        return watchersList;
    }

    protected WatchersList selectWatchersList(Object key) {
        return this.watchersList.get(Math.abs(key.hashCode() % this.watchersList.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryCompleteElseWatch(T operation, Set<Object> watchKeys) {
        Preconditions.checkArgument((watchKeys.size() > 0 ? 1 : 0) != 0, (Object)"The watch key list can't be empty");
        boolean isCompletedByMe = ((DelayedOperation)operation).tryComplete();
        if (isCompletedByMe) {
            return true;
        }
        boolean watchCreated = false;
        for (Object key : watchKeys) {
            if (((DelayedOperation)operation).isCompleted()) {
                return false;
            }
            this.watchForOperation(key, operation);
            if (watchCreated) continue;
            watchCreated = true;
            this.estimatedTotalOperations.incrementAndGet();
        }
        Iterator<Object> iterator = operation;
        synchronized (iterator) {
            isCompletedByMe = ((DelayedOperation)operation).tryComplete();
            if (isCompletedByMe) {
                return true;
            }
        }
        if (!((DelayedOperation)operation).isCompleted()) {
            this.timeoutTimer.add((TimerTask)operation);
            if (((DelayedOperation)operation).isCompleted()) {
                ((TimerTask)operation).cancel();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkAndComplete(Object key) {
        Watchers watchers = null;
        WatchersList watchersList = this.selectWatchersList(key);
        watchersList.lock();
        try {
            watchers = watchersList.getWatchers(key);
        }
        finally {
            watchersList.unlock();
        }
        if (watchers == null) {
            return 0;
        }
        return watchers.tryCompleteWatched();
    }

    private int delayed() {
        return this.timeoutTimer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchForOperation(Object key, T operation) {
        WatchersList watchersList = this.selectWatchersList(key);
        watchersList.lock();
        try {
            Watchers oldWatcher;
            Watchers watcher = watchersList.getWatchers(key);
            if (watcher == null && (oldWatcher = watchersList.putIfAbsentWatchers(key, watcher = new Watchers(key))) != null) {
                watcher = oldWatcher;
            }
            watcher.watch(operation);
        }
        finally {
            watchersList.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeyIfEmpty(Object key, Watchers watchers) {
        WatchersList watchersList = this.selectWatchersList(key);
        watchersList.lock();
        try {
            if (watchersList.getWatchers(key) == null || !watchersList.getWatchers(key).equals(watchers)) {
                return;
            }
            if (watchers != null && watchers.isEmpty()) {
                watchersList.removeWatchers(key);
            }
        }
        finally {
            watchersList.unlock();
        }
    }

    private void advanceClock(long timeoutMs) {
        this.timeoutTimer.advanceClock(timeoutMs);
        if (this.estimatedTotalOperations.get() - this.delayed() > this.purgeInterval) {
            this.estimatedTotalOperations.getAndSet(this.delayed());
            int sum = 0;
            for (WatchersList watcherList : this.watchersList) {
                for (Watchers watchers : watcherList.allWatchers()) {
                    sum += watchers.purgeCompleted();
                }
            }
        }
    }

    private class ExpiredOperationReaper
    extends Thread {
        private String name;
        private boolean isInterruptible;
        private AtomicBoolean isRunning = new AtomicBoolean(true);
        private CountDownLatch shutdownLatch = new CountDownLatch(1);

        private ExpiredOperationReaper(String expirationReaper) {
            this(expirationReaper, false);
        }

        private ExpiredOperationReaper(String name, boolean isInterruptible) {
            super.setDaemon(false);
            super.setName(name);
            this.name = name;
            this.isInterruptible = isInterruptible;
        }

        public void shutdown() {
            this.initiateShutdown();
            this.awaitShutdown();
        }

        private boolean initiateShutdown() {
            if (this.isRunning.compareAndSet(true, false)) {
                this.isRunning.set(false);
                if (this.isInterruptible) {
                    this.interrupt();
                }
                return true;
            }
            return false;
        }

        private void awaitShutdown() {
            try {
                this.shutdownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void doWork() {
            DelayedOperationManager.this.advanceClock(200L);
        }

        @Override
        public void run() {
            try {
                while (this.isRunning.get()) {
                    this.doWork();
                }
            }
            catch (Exception e) {
                if (this.isRunning.get()) {
                    // empty if block
                }
            }
            this.shutdownLatch.countDown();
        }
    }

    private class Watchers {
        private Object key;
        private ConcurrentLinkedQueue<T> operations = new ConcurrentLinkedQueue();

        private Watchers(Object key) {
            this.key = key;
        }

        private int countWatched() {
            return this.operations.size();
        }

        private boolean isEmpty() {
            return this.operations.isEmpty();
        }

        private void watch(T t) {
            this.operations.add(t);
        }

        private int tryCompleteWatched() {
            int completed = 0;
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                DelayedOperation curr = (DelayedOperation)iter.next();
                if (curr.isCompleted()) {
                    iter.remove();
                    continue;
                }
                if (!curr.safeTryComplete()) continue;
                iter.remove();
                ++completed;
            }
            if (this.operations.isEmpty()) {
                DelayedOperationManager.this.removeKeyIfEmpty(this.key, this);
            }
            return completed;
        }

        private int purgeCompleted() {
            int purged = 0;
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                DelayedOperation curr = (DelayedOperation)iter.next();
                if (!curr.isCompleted()) continue;
                iter.remove();
                ++purged;
            }
            if (this.operations.isEmpty()) {
                DelayedOperationManager.this.removeKeyIfEmpty(this.key, this);
            }
            return purged;
        }
    }

    private class WatchersList {
        private ReentrantLock lock = new ReentrantLock();
        private ConcurrentMap<Object, Watchers> watchersForKey = new ConcurrentHashMap<Object, Watchers>();

        private WatchersList() {
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public Watchers getWatchers(Object key) {
            return (Watchers)this.watchersForKey.get(key);
        }

        public Watchers removeWatchers(Object key) {
            return (Watchers)this.watchersForKey.remove(key);
        }

        public Watchers putIfAbsentWatchers(Object key, Watchers watchers) {
            return this.watchersForKey.putIfAbsent(key, watchers);
        }

        public List<Watchers> allWatchers() {
            return Lists.newArrayList(this.watchersForKey.values());
        }
    }
}

