/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.delay;

import com.google.common.base.Preconditions;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.joyqueue.toolkit.delay.TimerTask;
import org.joyqueue.toolkit.delay.TimerTaskList;
import org.joyqueue.toolkit.delay.TimingWheel;
import org.joyqueue.toolkit.time.SystemClock;

public class Timer {
    private final DelayQueue<TimerTaskList> delayQueue = new DelayQueue();
    private final TimingWheel timingWheel;
    private final ExecutorService taskExecutor;
    private final AtomicInteger taskCounter = new AtomicInteger(0);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    public Timer(ExecutorService taskExecutor) {
        this(taskExecutor, 1, 20, SystemClock.now());
    }

    public Timer(ExecutorService taskExecutor, int tickMs, int wheelSize, long startMs) {
        Preconditions.checkArgument((taskExecutor != null ? 1 : 0) != 0, (Object)"ExecutorService can't be null");
        this.taskExecutor = taskExecutor;
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
    }

    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.addTimerTaskEntry(new TimerTaskList.TimerTaskEntry(timerTask));
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void addTimerTaskEntry(TimerTaskList.TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry) && !timerTaskEntry.cancelled()) {
            this.taskExecutor.submit(timerTaskEntry.timerTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean advanceClock(long timeoutMs) {
        TimerTaskList bucket = null;
        try {
            bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (bucket != null) {
            this.writeLock.lock();
            try {
                while (bucket != null) {
                    this.timingWheel.advanceClock(bucket.getExpiration());
                    bucket.flush(this);
                    bucket = (TimerTaskList)this.delayQueue.poll();
                }
            }
            finally {
                this.writeLock.unlock();
            }
            return true;
        }
        return false;
    }

    public int size() {
        return this.taskCounter.get();
    }
}

