/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.delay;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.joyqueue.toolkit.delay.Timer;
import org.joyqueue.toolkit.delay.TimerTask;
import org.joyqueue.toolkit.time.SystemClock;

public class TimerTaskList
implements Delayed {
    private final TimerTaskEntry root;
    private final AtomicLong expiration = new AtomicLong(-1L);
    private final AtomicInteger taskCounter;

    public TimerTaskList(AtomicInteger taskCounter) {
        this.root = new TimerTaskEntry(null);
        this.root.next = this.root;
        this.root.prev = this.root;
        this.taskCounter = taskCounter;
    }

    public boolean setExpiration(long expirationMs) {
        return this.expiration.getAndSet(expirationMs) != expirationMs;
    }

    public long getExpiration() {
        return this.expiration.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimerTaskEntry timerTaskEntry) {
        boolean done = false;
        while (!done) {
            timerTaskEntry.remove();
            TimerTaskList timerTaskList = this;
            synchronized (timerTaskList) {
                if (timerTaskEntry.list == null) {
                    TimerTaskEntry tail = this.root.prev;
                    timerTaskEntry.next = this.root;
                    timerTaskEntry.prev = tail;
                    timerTaskEntry.list = this;
                    tail.next = timerTaskEntry;
                    this.root.prev = timerTaskEntry;
                    this.taskCounter.incrementAndGet();
                    done = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TimerTaskEntry timerTaskEntry) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            if (timerTaskEntry.list == this) {
                timerTaskEntry.next.prev = timerTaskEntry.prev;
                timerTaskEntry.prev.next = timerTaskEntry.next;
                timerTaskEntry.next = null;
                timerTaskEntry.prev = null;
                timerTaskEntry.list = null;
                this.taskCounter.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Timer timer) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            TimerTaskEntry head = this.root.next;
            while (head != this.root) {
                this.remove(head);
                timer.addTimerTaskEntry(head);
                head = this.root.next;
            }
            this.expiration.set(-1L);
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(Math.max(this.getExpiration() - SystemClock.now(), 0L), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        TimerTaskList other = (TimerTaskList)d;
        if (this.getExpiration() < other.getExpiration()) {
            return -1;
        }
        if (this.getExpiration() > other.getExpiration()) {
            return 1;
        }
        return 0;
    }

    public static class TimerTaskEntry {
        private volatile TimerTaskList list = null;
        private TimerTaskEntry next = null;
        private TimerTaskEntry prev = null;
        public TimerTask timerTask;

        public TimerTaskEntry(TimerTask timerTask) {
            this.timerTask = timerTask;
            if (this.timerTask != null) {
                this.timerTask.setTimerTaskEntry(this);
            }
        }

        public boolean cancelled() {
            return this.timerTask.getTimerTaskEntry() != this;
        }

        public void remove() {
            TimerTaskList currentList = this.list;
            while (currentList != null) {
                currentList.remove(this);
                currentList = this.list;
            }
        }
    }
}

