/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.joyqueue.toolkit.io.Compressor;

public class Zip
implements Compressor {
    public static final Compressor INSTANCE = new Zip();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(byte[] buf, int offset, int size, OutputStream out) throws IOException {
        if (buf == null || out == null) {
            return;
        }
        try (ZipOutputStream zos = new ZipOutputStream(out);){
            zos.putNextEntry(new ZipEntry("0"));
            zos.write(buf, offset, size);
            zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(byte[] buf, int offset, int size, OutputStream out) throws IOException {
        if (buf == null || buf.length == 0 || size <= 0 || offset >= buf.length || out == null) {
            return;
        }
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(buf, offset, size));){
            zis.getNextEntry();
            byte[] buffer = new byte[1024];
            int position = -1;
            while ((position = zis.read(buffer)) != -1) {
                out.write(buffer, 0, position);
            }
        }
    }
}

