/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.joyqueue.toolkit.io.ZipDeflater;
import org.joyqueue.toolkit.io.ZipInflater;

public class ZipUtil {
    public static void compress(String src, OutputStream out) throws IOException {
        if (src == null) {
            return;
        }
        ZipUtil.compress(src.getBytes(), out);
    }

    public static void compress(byte[] src, OutputStream out) throws IOException {
        if (src == null || src.length == 0 || out == null) {
            return;
        }
        try (ZipOutputStream zout = new ZipOutputStream(out);){
            zout.putNextEntry(new ZipEntry("0"));
            zout.write(src);
            zout.closeEntry();
        }
    }

    public static byte[] compress(String src) throws IOException {
        if (src == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ZipUtil.compress(src, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static byte[] compress(byte[] src) throws IOException {
        if (src == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ZipUtil.compress(src, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(byte[] buf) throws IOException {
        if (buf == null || buf.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(buf));
        try {
            zin.getNextEntry();
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = zin.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            String string = out.toString();
            return string;
        }
        finally {
            if (zin != null) {
                zin.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressByZlib(byte[] src, int offset, int size) throws IOException {
        if (src == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
        ZipDeflater deflater = new ZipDeflater();
        deflater.reset();
        deflater.setInput(src, offset, size);
        deflater.finish();
        byte[] block = new byte[1024];
        try {
            while (!deflater.finished()) {
                int len = deflater.deflate(block);
                bos.write(block, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            deflater.end();
            if (bos != null) {
                bos.close();
            }
        }
    }

    public static byte[] decompressByZlib(byte[] buf, int offset, int size) throws IOException {
        if (buf == null || buf.length == 0 || size <= 0 || offset >= buf.length) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size * 4);
        ZipInflater inflater = new ZipInflater();
        inflater.reset();
        inflater.setInput(buf, offset, size);
        byte[] block = new byte[1024];
        try {
            while (!inflater.finished()) {
                int len = inflater.inflate(block);
                bos.write(block, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        finally {
            inflater.end();
            if (bos != null) {
                bos.close();
            }
        }
    }
}

