/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.joyqueue.toolkit.io.Compressor;

public class Zlib
implements Compressor {
    public static final Compressor INSTANCE = new Zlib();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(byte[] buf, int offset, int size, OutputStream out) throws IOException {
        if (buf == null || out == null) {
            return;
        }
        Deflater deflater = new Deflater();
        deflater.reset();
        deflater.setInput(buf, offset, size);
        deflater.finish();
        byte[] block = new byte[1024];
        try {
            while (!deflater.finished()) {
                int len = deflater.deflate(block);
                out.write(block, 0, len);
            }
        }
        finally {
            deflater.end();
        }
    }

    @Override
    public void decompress(byte[] buf, int offset, int size, OutputStream out) throws IOException {
        if (buf == null || buf.length == 0 || size <= 0 || offset >= buf.length || out == null) {
            return;
        }
        Inflater inflater = new Inflater();
        inflater.reset();
        inflater.setInput(buf, offset, size);
        byte[] block = new byte[1024];
        try {
            while (!inflater.finished()) {
                int len = inflater.inflate(block);
                out.write(block, 0, len);
            }
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        finally {
            inflater.end();
        }
    }
}

