/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.lang;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileLock;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.joyqueue.toolkit.lang.LifeCycle;

public class Close {
    private static Close instance = new Close();

    public static Close close(Closeable io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static Close close(Closeable ... resources) {
        if (resources != null) {
            for (Closeable resource : resources) {
                if (resource == null) continue;
                try {
                    resource.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return instance;
    }

    public static Close close(Connection connection, Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static Close close(LifeCycle lifeCycle) {
        if (lifeCycle != null) {
            lifeCycle.stop();
        }
        return instance;
    }

    public static Close close(LifeCycle ... lifeCycles) {
        if (lifeCycles != null) {
            for (LifeCycle lifeCycle : lifeCycles) {
                if (lifeCycle == null) continue;
                lifeCycle.stop();
            }
        }
        return instance;
    }

    public static <T extends LifeCycle> Close close(Collection<T> lifeCycles) {
        if (lifeCycles != null && lifeCycles.size() > 0) {
            for (LifeCycle lifeCycle : lifeCycles) {
                Close.close(lifeCycle);
            }
        }
        return instance;
    }

    public static Close close(Timer timer) {
        if (timer != null) {
            try {
                timer.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return instance;
    }

    public static Close close(FileLock lock) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static Close close(Thread thread) {
        if (thread != null) {
            thread.interrupt();
        }
        return instance;
    }

    public static Close close(DataSource dataSource) {
        if (dataSource == null) {
            return instance;
        }
        if (dataSource instanceof Closeable) {
            return Close.close((Closeable)((Object)dataSource));
        }
        Class<?> clazz = dataSource.getClass();
        try {
            Method method = clazz.getDeclaredMethod("close", new Class[0]);
            method.invoke((Object)dataSource, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return instance;
    }

    public static Close close(ExecutorService executor) {
        if (null != executor && !executor.isTerminated()) {
            executor.shutdown();
            try {
                executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!executor.isTerminated()) {
                executor.shutdownNow();
            }
        }
        return instance;
    }

    public static Close close(ExecutorService executor, long timeout) {
        if (executor != null) {
            if (timeout <= 0L) {
                executor.shutdownNow();
            } else {
                executor.shutdown();
                try {
                    if (!executor.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                        executor.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return instance;
    }
}

