/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.lang;

import java.lang.reflect.Field;
import org.joyqueue.toolkit.lang.Getter;
import org.joyqueue.toolkit.reflect.Reflect;

public class Getters {
    public static Getter constant(Object value) {
        return new ConstantGetter(value);
    }

    public static Getter field(Field field, Object target, boolean cache) {
        return new FieldGetter(field, target, cache);
    }

    protected static class ConstantGetter
    implements Getter {
        protected Object value;

        public ConstantGetter(Object value) {
            this.value = value;
        }

        @Override
        public Object get() {
            return this.value;
        }
    }

    protected static class FieldGetter
    implements Getter {
        protected Field field;
        protected Object target;
        protected boolean cache;
        protected Object value;
        protected boolean flag;

        public FieldGetter(Field field, Object target, boolean cache) {
            this.field = field;
            this.target = target;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }

        @Override
        public Object get() {
            if (!this.cache) {
                return Reflect.get(this.field, this.target);
            }
            if (!this.flag) {
                this.value = Reflect.get(this.field, this.target);
                this.flag = true;
            }
            return this.value;
        }
    }
}

