/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.metric;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joyqueue.toolkit.format.Format;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metric {
    private final List<MetricInstance> metricInstances;
    private final String name;
    private final String[] latencies;
    private final String[] counters;
    private final String[] traffics;
    private long resetTime = SystemClock.now();
    private static final Logger logger = LoggerFactory.getLogger(Metric.class);

    public Metric(String name, int instanceCount, String[] latencies, String[] counters, String[] traffics) {
        this.name = name;
        this.metricInstances = new ArrayList<MetricInstance>(instanceCount);
        IntStream.range(0, instanceCount).forEach(i -> this.metricInstances.add(new MetricInstance(latencies, counters, traffics)));
        this.latencies = latencies;
        this.counters = counters;
        this.traffics = traffics;
    }

    public List<MetricInstance> getMetricInstances() {
        return this.metricInstances;
    }

    public String getName() {
        return this.name;
    }

    public void reportAndReset() {
        long reportTime = SystemClock.now();
        int intervalMs = (int)(reportTime - this.resetTime);
        logger.info(System.lineSeparator() + "{}\uff1a{}", (Object)this.name, (Object)Stream.of(Arrays.stream(this.counters).map(name -> {
            long cps = 0L;
            if (intervalMs > 0) {
                cps = this.metricInstances.stream().mapToLong(instance -> instance.getAndResetCounter((String)name)).sum() * 1000L / (long)intervalMs;
            }
            return String.format("%s: %d /S", name, cps);
        }), Arrays.stream(this.traffics).map(name -> {
            long cps = 0L;
            if (intervalMs > 0) {
                cps = this.metricInstances.stream().mapToLong(instance -> instance.getAndResetTraffic((String)name)).sum() * 1000L / (long)intervalMs;
            }
            return String.format("%s: %s/S", name, Format.formatSize(cps));
        }), Arrays.stream(this.latencies).map(name -> {
            long[] sorted = this.metricInstances.stream().map(instance -> instance.getAndResetLatencies((String)name)).flatMap(Collection::stream).mapToLong(Long::longValue).sorted().toArray();
            if (sorted.length > 0) {
                double avg = Arrays.stream(sorted).average().orElse(0.0) / 1000000.0;
                double tp90 = (double)sorted[(int)((double)sorted.length * 0.9)] / 1000000.0;
                double tp99 = (double)sorted[(int)((double)sorted.length * 0.99)] / 1000000.0;
                double max = (double)sorted[sorted.length - 1] / 1000000.0;
                return String.format("%s: %.4f/%.4f/%.4f/%.4f ms", name, avg, tp90, tp99, max);
            }
            return String.format("%s: 0/0/0/0 ms", name);
        })).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.joining(", ")));
        this.resetTime = reportTime;
    }

    public static class MetricInstance {
        private Map<String, Latency> latencies;
        private Map<String, Counter> counters;
        private Map<String, Traffic> traffics;

        MetricInstance(String[] latencyNames, String[] counterNames, String[] trafficNames) {
            this.latencies = new HashMap<String, Latency>(latencyNames.length);
            Arrays.stream(latencyNames).forEach(name -> this.latencies.put((String)name, new Latency()));
            this.counters = new HashMap<String, Counter>(counterNames.length);
            Arrays.stream(counterNames).forEach(name -> this.counters.put((String)name, new Counter()));
            this.traffics = new HashMap<String, Traffic>(trafficNames.length);
            Arrays.stream(trafficNames).forEach(name -> this.traffics.put((String)name, new Traffic()));
        }

        public void addLatency(String name, long value) {
            this.latencies.get(name).add(value);
        }

        public void addCounter(String name, long value) {
            this.counters.get(name).add(value);
        }

        public void addTraffic(String name, long value) {
            this.traffics.get(name).add(value);
        }

        public List<Long> getAndResetLatencies(String name) {
            return this.latencies.get(name).getAndReset();
        }

        public long getAndResetCounter(String name) {
            return this.counters.get(name).getAndReset();
        }

        public long getAndResetTraffic(String name) {
            return this.traffics.get(name).getAndReset();
        }
    }

    public static class Traffic {
        private final AtomicLong atomicLong = new AtomicLong(0L);

        void add(long count) {
            this.atomicLong.addAndGet(count);
        }

        long getAndReset() {
            return this.atomicLong.getAndSet(0L);
        }
    }

    public static class Counter {
        private final AtomicLong atomicLong = new AtomicLong(0L);

        void add(long count) {
            this.atomicLong.addAndGet(count);
        }

        long getAndReset() {
            return this.atomicLong.getAndSet(0L);
        }
    }

    public static class Latency {
        private List<Long> latencies = Collections.synchronizedList(new LinkedList());

        void add(long latency) {
            this.latencies.add(latency);
        }

        List<Long> getAndReset() {
            ArrayList<Long> ret = new ArrayList<Long>(this.latencies);
            this.latencies.clear();
            return ret;
        }
    }
}

