/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.network;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.joyqueue.toolkit.network.Lan;
import sun.net.util.IPAddressUtil;

public class IpUtil {
    public static String IPV4_PORT_SEPARATOR = ":";
    public static String IPV6_PORT_SEPARATOR = "_";
    public static String IPV4_SEPARATOR = ".";
    public static String IPV6_SEPARATOR = ":";
    public static String MANAGE_IP = "10.";
    public static String NET_INTERFACE;
    public static final Lan INTRANET;
    public static boolean PREFER_IPV6;

    public static List<String> getLocalIps() {
        return IpUtil.getLocalIps(null, null);
    }

    public static List<String> getLocalIps(String nic, String exclude) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                if (nic != null && !nic.isEmpty() && !ni.getName().equals(nic)) continue;
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    InetAddress address = ias.nextElement();
                    if (address.isLoopbackAddress() || address.isAnyLocalAddress() || (!(address instanceof Inet4Address) || PREFER_IPV6) && (!(address instanceof Inet6Address) || !PREFER_IPV6)) continue;
                    result.add(address.getHostAddress());
                }
            }
            int count = result.size();
            if (count <= 1) {
                return result;
            }
            if (exclude != null && !exclude.isEmpty()) {
                for (int i = count - 1; i >= 0; --i) {
                    String ip = (String)result.get(i);
                    if (!ip.startsWith(exclude)) continue;
                    result.remove(i);
                    if (--count == 1) break;
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLocalIp(String nic, String manageIp) {
        List<String> ips = IpUtil.getLocalIps(nic, manageIp);
        if (ips != null && !ips.isEmpty()) {
            if (ips.size() == 1) {
                return ips.get(0);
            }
            if (!PREFER_IPV6) {
                for (String ip : ips) {
                    if (!INTRANET.contains(ip)) continue;
                    return ip;
                }
            }
            return ips.get(0);
        }
        return null;
    }

    public static String getLocalIp(String manageIp) {
        return IpUtil.getLocalIp(NET_INTERFACE, manageIp);
    }

    public static String getLocalIp() {
        return IpUtil.getDefaultLocalIp();
    }

    private static String getDefaultLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            List<String> ips = IpUtil.getLocalIps();
            if (null != ips && !ips.isEmpty()) {
                return ips.get(0);
            }
            return "127.0.0.1";
        }
    }

    public static String toAddress(SocketAddress address) {
        if (address == null) {
            return null;
        }
        if (address instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)address;
            StringBuilder builder = new StringBuilder(50);
            if (address instanceof InetSocketAddress) {
                builder.append(isa.getAddress().getHostAddress());
                String separator = IpUtil.isValidIpV4Address(((InetSocketAddress)address).getHostString()) ? IPV4_PORT_SEPARATOR : IPV6_PORT_SEPARATOR;
                builder.append(separator).append(isa.getPort());
            }
            return builder.toString();
        }
        return address.toString();
    }

    public static String toIp(byte[] address) {
        if (address == null || address.length < 4) {
            return null;
        }
        int pos = 0;
        if (address.length == 6 || address.length == 18) {
            pos += 2;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = pos; i < address.length - 1; ++i) {
            if (address.length <= 6) {
                builder.append(address[pos++] & 0xFF).append(IPV4_SEPARATOR);
                continue;
            }
            builder = new StringBuilder(20);
            builder.append(address[pos++] & 0xFF).append(IPV6_SEPARATOR);
        }
        builder.append(address[pos++] & 0xFF);
        return builder.toString();
    }

    public static byte[] toByte(String address) {
        if (address == null || address.isEmpty()) {
            return null;
        }
        String upperAddress = address.toUpperCase();
        StringBuilder host = new StringBuilder();
        char[] chars = upperAddress.toCharArray();
        int start = -1;
        int end = -1;
        int index = 0;
        char sep = ' ';
        block4: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    if (start == -1) {
                        start = i;
                    }
                    end = i;
                    continue block4;
                }
                case '.': 
                case ':': 
                case '_': {
                    ++index;
                    if (start == -1) {
                        return null;
                    }
                    if (start != 0) {
                        host.append(sep);
                    }
                    host.append(new String(chars, start, end - start + 1));
                    sep = ch;
                    start = -1;
                    end = -1;
                    continue block4;
                }
                default: {
                    return null;
                }
            }
        }
        String last = new String(chars, start, end - start + 1);
        if (index == 3 || index == 7) {
            host.append(String.valueOf(sep)).append(last);
            return IpUtil.toByteWithoutPort(host.toString());
        }
        byte[] data = IpUtil.toByteWithoutPort(host.toString());
        int port = Integer.valueOf(new String(chars, start, end - start + 1));
        byte[] result = new byte[data.length + 2];
        System.arraycopy(data, 0, result, 2, data.length);
        result[1] = (byte)(port >> 8 & 0xFF);
        result[0] = (byte)(port & 0xFF);
        return result;
    }

    public static byte[] toByte(InetSocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new IllegalArgumentException("socketAddress is null");
        }
        InetAddress inetAddress = socketAddress.getAddress();
        if (inetAddress == null) {
            throw new IllegalArgumentException("socketAddress is invalid");
        }
        byte[] address = inetAddress.getAddress();
        byte[] result = new byte[address.length + 2];
        System.arraycopy(address, 0, result, 2, address.length);
        int port = socketAddress.getPort();
        result[1] = (byte)(port >> 8 & 0xFF);
        result[0] = (byte)(port & 0xFF);
        return result;
    }

    public static InetSocketAddress toAddress(byte[] address) {
        if (address == null || address.length != 6 && address.length != 18) {
            throw new IllegalArgumentException("address is invalid");
        }
        int port = address[0] & 0xFF;
        port |= address[1] << 8 & 0xFF00;
        try {
            InetAddress addr = InetAddress.getByAddress(null, Arrays.copyOfRange(address, 2, address.length));
            return new InetSocketAddress(addr, port);
        }
        catch (UnknownHostException ignored) {
            return null;
        }
    }

    public static void toAddress(byte[] address, StringBuilder builder) {
        if (builder == null) {
            return;
        }
        if (address == null) {
            throw new IllegalArgumentException("address is invalid");
        }
        if (address.length < 4) {
            throw new IllegalArgumentException("address is invalid");
        }
        int pos = 0;
        int port = 0;
        if (address.length >= 6) {
            port = address[pos++] & 0xFF;
            port |= address[pos++] << 8 & 0xFF00;
        }
        builder.append(address[pos++] & 0xFF).append('.');
        builder.append(address[pos++] & 0xFF).append('.');
        builder.append(address[pos++] & 0xFF).append('.');
        builder.append(address[pos++] & 0xFF);
        if (address.length >= 6) {
            builder.append(':').append(port);
        }
    }

    public static int[] parseIp(String ip) {
        int part;
        if (!IpUtil.isValidIpV4Address(ip)) {
            return null;
        }
        if (ip == null || ip.isEmpty()) {
            return null;
        }
        int[] parts = new int[4];
        int index = 0;
        int start = -1;
        int end = -1;
        char[] chars = ip.toCharArray();
        char ch = '\u0000';
        block4: for (int i = 0; i < chars.length; ++i) {
            if (index > 3) {
                return null;
            }
            ch = chars[i];
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (start == -1) {
                        start = i;
                    }
                    if ((end = i) - start <= 2) continue block4;
                    return null;
                }
                case '.': {
                    if (start == -1) {
                        return null;
                    }
                    part = Integer.parseInt(new String(chars, start, end - start + 1));
                    if (part > 255) {
                        return null;
                    }
                    parts[index++] = part;
                    start = -1;
                    end = -1;
                    continue block4;
                }
                default: {
                    return null;
                }
            }
        }
        if (start > -1) {
            part = Integer.parseInt(new String(chars, start, end - start + 1));
            if (part > 255) {
                return null;
            }
            parts[index] = part;
            return (int[])(index == 3 ? parts : null);
        }
        return null;
    }

    public static long toLong(String ip) {
        int[] data = IpUtil.parseIp(ip);
        if (data == null) {
            throw new IllegalArgumentException(String.format("invalid ip %s", ip));
        }
        long result = 0L;
        result += (long)data[0] << 24;
        result += (long)data[1] << 16;
        result += (long)data[2] << 8;
        return result += (long)data[3];
    }

    public static String toIp(long ip) {
        StringBuffer sb = new StringBuffer(20);
        long part1 = (ip & 0xFFFFFFFFFFFFFFFFL) >>> 24;
        long part2 = (ip & 0xFFFFFFL) >>> 16;
        long part3 = (ip & 0xFFFFL) >>> 8;
        long part4 = ip & 0xFFL;
        sb.append(part1).append('.');
        sb.append(part2).append('.');
        sb.append(part3).append('.');
        sb.append(part4);
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("java.net.preferIPv6Stack", "true");
        List<String> ips = IpUtil.getLocalIps();
        ips.forEach(ip -> System.out.println((String)ip));
        String ip2 = IpUtil.getLocalIp();
        System.out.println("local ip :" + ip2);
        String v6Str = "fe80:0:0:0:10af:7794:db80:1ba1";
        String v4Str = "127.0.0.1";
        System.out.println(IPAddressUtil.isIPv4LiteralAddress(v6Str));
        System.out.println(IPAddressUtil.isIPv6LiteralAddress(v4Str));
        byte[] v4Byte = IPAddressUtil.textToNumericFormatV4(v4Str);
        byte[] v6Byte = IPAddressUtil.textToNumericFormatV6(v6Str);
        StringBuilder buffer = new StringBuilder();
        IpUtil.toAddress(v4Byte, buffer);
        System.out.println("buffer_v4:" + buffer.toString());
        buffer = new StringBuilder();
        IpUtil.toAddress(v6Byte, buffer);
        System.out.println("hex_v6:" + Integer.toHexString(v6Byte[0] & 0xFF).toUpperCase());
        System.out.println("hex_v6:" + Integer.toHexString(v6Byte[1] & 0xFF).toUpperCase());
        System.out.println("buffer_v6:" + buffer.toString());
        InetSocketAddress address = new InetSocketAddress(v6Str, 80);
        v6Byte = address.getAddress().getAddress();
        System.out.println("hex_v6_1:" + Integer.toHexString(v6Byte[0] & 0xFF).toUpperCase());
    }

    private static byte[] toByteWithoutPort(String ipAddressString) {
        if (IpUtil.isValidIpV4Address(ipAddressString)) {
            StringTokenizer tokenizer = new StringTokenizer(ipAddressString, ".");
            byte[] byteAddress = new byte[4];
            for (int i = 0; i < 4; ++i) {
                String token = tokenizer.nextToken();
                int tempInt = Integer.parseInt(token);
                byteAddress[i] = (byte)tempInt;
            }
            return byteAddress;
        }
        if (IpUtil.isValidIpV6Address(ipAddressString)) {
            int i;
            int percentPos;
            if (ipAddressString.charAt(0) == '[') {
                ipAddressString = ipAddressString.substring(1, ipAddressString.length() - 1);
            }
            if ((percentPos = ipAddressString.indexOf(37)) >= 0) {
                ipAddressString = ipAddressString.substring(0, percentPos);
            }
            StringTokenizer tokenizer = new StringTokenizer(ipAddressString, ":.", true);
            ArrayList<String> hexStrings = new ArrayList<String>();
            ArrayList<String> decStrings = new ArrayList<String>();
            String token = "";
            String prevToken = "";
            int doubleColonIndex = -1;
            while (tokenizer.hasMoreTokens()) {
                prevToken = token;
                token = tokenizer.nextToken();
                if (":".equals(token)) {
                    if (":".equals(prevToken)) {
                        doubleColonIndex = hexStrings.size();
                        continue;
                    }
                    if (prevToken.isEmpty()) continue;
                    hexStrings.add(prevToken);
                    continue;
                }
                if (!".".equals(token)) continue;
                decStrings.add(prevToken);
            }
            if (":".equals(prevToken)) {
                if (":".equals(token)) {
                    doubleColonIndex = hexStrings.size();
                } else {
                    hexStrings.add(token);
                }
            } else if (".".equals(prevToken)) {
                decStrings.add(token);
            }
            int hexStringsLength = 8;
            if (!decStrings.isEmpty()) {
                hexStringsLength -= 2;
            }
            if (doubleColonIndex != -1) {
                int numberToInsert = hexStringsLength - hexStrings.size();
                for (i = 0; i < numberToInsert; ++i) {
                    hexStrings.add(doubleColonIndex, "0");
                }
            }
            byte[] ipByteArray = new byte[16];
            for (i = 0; i < hexStrings.size(); ++i) {
                IpUtil.convertToBytes((String)hexStrings.get(i), ipByteArray, i * 2);
            }
            for (i = 0; i < decStrings.size(); ++i) {
                ipByteArray[i + 12] = (byte)(Integer.parseInt((String)decStrings.get(i)) & 0xFF);
            }
            return ipByteArray;
        }
        return null;
    }

    private static void convertToBytes(String hexWord, byte[] ipByteArray, int byteIndex) {
        int charValue;
        int hexWordLength = hexWord.length();
        int hexWordIndex = 0;
        ipByteArray[byteIndex] = 0;
        ipByteArray[byteIndex + 1] = 0;
        if (hexWordLength > 3) {
            charValue = IpUtil.getIntValue(hexWord.charAt(hexWordIndex++));
            int n = byteIndex;
            ipByteArray[n] = (byte)(ipByteArray[n] | charValue << 4);
        }
        if (hexWordLength > 2) {
            charValue = IpUtil.getIntValue(hexWord.charAt(hexWordIndex++));
            int n = byteIndex;
            ipByteArray[n] = (byte)(ipByteArray[n] | charValue);
        }
        if (hexWordLength > 1) {
            charValue = IpUtil.getIntValue(hexWord.charAt(hexWordIndex++));
            int n = byteIndex + 1;
            ipByteArray[n] = (byte)(ipByteArray[n] | charValue << 4);
        }
        charValue = IpUtil.getIntValue(hexWord.charAt(hexWordIndex));
        int n = byteIndex + 1;
        ipByteArray[n] = (byte)(ipByteArray[n] | charValue & 0xF);
    }

    static int getIntValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        c = Character.toLowerCase(c);
        switch (c) {
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public static boolean isValidIpV6Address(String ipAddress) {
        int length = ipAddress.length();
        boolean doubleColon = false;
        int numberOfColons = 0;
        int numberOfPeriods = 0;
        int numberOfPercent = 0;
        StringBuilder word = new StringBuilder();
        char c = '\u0000';
        int offset = 0;
        if (length < 2) {
            return false;
        }
        block9: for (int i = 0; i < length; ++i) {
            char prevChar = c;
            c = ipAddress.charAt(i);
            switch (c) {
                case '[': {
                    if (i != 0) {
                        return false;
                    }
                    if (ipAddress.charAt(length - 1) != ']') {
                        return false;
                    }
                    offset = 1;
                    if (length >= 4) continue block9;
                    return false;
                }
                case ']': {
                    if (i != length - 1) {
                        return false;
                    }
                    if (ipAddress.charAt(0) == '[') continue block9;
                    return false;
                }
                case '.': {
                    if (++numberOfPeriods > 3) {
                        return false;
                    }
                    if (!IpUtil.isValidIp4Word(word.toString())) {
                        return false;
                    }
                    if (numberOfColons != 6 && !doubleColon) {
                        return false;
                    }
                    if (numberOfColons == 7 && ipAddress.charAt(offset) != ':' && ipAddress.charAt(1 + offset) != ':') {
                        return false;
                    }
                    word.delete(0, word.length());
                    continue block9;
                }
                case ':': {
                    if (i == offset && (ipAddress.length() <= i || ipAddress.charAt(i + 1) != ':')) {
                        return false;
                    }
                    if (++numberOfColons > 7) {
                        return false;
                    }
                    if (numberOfPeriods > 0) {
                        return false;
                    }
                    if (prevChar == ':') {
                        if (doubleColon) {
                            return false;
                        }
                        doubleColon = true;
                    }
                    word.delete(0, word.length());
                    continue block9;
                }
                case '%': {
                    if (numberOfColons == 0) {
                        return false;
                    }
                    ++numberOfPercent;
                    if (i + 1 >= length) {
                        return false;
                    }
                    try {
                        if (Integer.parseInt(ipAddress.substring(i + 1)) >= 0) continue block9;
                        return false;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                default: {
                    if (numberOfPercent == 0) {
                        if (word != null && word.length() > 3) {
                            return false;
                        }
                        if (!IpUtil.isValidHexChar(c)) {
                            return false;
                        }
                    }
                    word.append(c);
                }
            }
        }
        if (numberOfPeriods > 0) {
            if (numberOfPeriods != 3 || !IpUtil.isValidIp4Word(word.toString()) || numberOfColons >= 7) {
                return false;
            }
        } else {
            if (numberOfColons != 7 && !doubleColon) {
                return false;
            }
            if (numberOfPercent == 0 && word.length() == 0 && ipAddress.charAt(length - 1 - offset) == ':' && ipAddress.charAt(length - 2 - offset) != ':') {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIp4Word(String word) {
        if (word.length() < 1 || word.length() > 3) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return Integer.parseInt(word) <= 255;
    }

    static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean isValidIpV4Address(String value) {
        int periods = 0;
        int length = value.length();
        if (length > 15) {
            return false;
        }
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '.') {
                if (++periods > 3) {
                    return false;
                }
                if (word.length() == 0) {
                    return false;
                }
                if (Integer.parseInt(word.toString()) > 255) {
                    return false;
                }
                word.delete(0, word.length());
                continue;
            }
            if (!Character.isDigit(c)) {
                return false;
            }
            if (word.length() > 2) {
                return false;
            }
            word.append(c);
        }
        if (word.length() == 0 || Integer.parseInt(word.toString()) > 255) {
            return false;
        }
        return periods == 3;
    }

    static {
        INTRANET = new Lan("172.16.0.0/12;192.168.0.0/16;10.0.0.0/8");
        PREFER_IPV6 = false;
        NET_INTERFACE = System.getProperty("nic");
        MANAGE_IP = System.getProperty("manage_ip", MANAGE_IP);
        PREFER_IPV6 = Boolean.valueOf(System.getProperty("java.net.preferIPv6Stack", "false"));
    }
}

