/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.network;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.joyqueue.toolkit.network.Segment;

public class Lan {
    private List<Segment> segments = new ArrayList<Segment>();
    private int id;
    private String name;

    public Lan(String ips) {
        this(0, null, ips);
    }

    public Lan(int id, String name, String ips) {
        this.id = id;
        this.name = name;
        if (ips != null && !ips.isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(ips, ",;", false);
            while (tokenizer.hasMoreTokens()) {
                String segment = tokenizer.nextToken();
                if (segment == null || segment.isEmpty()) continue;
                this.segments.add(new Segment(segment));
            }
        }
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(String ip) {
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        if (this.segments != null) {
            for (Segment segment : this.segments) {
                if (!segment.contains(ip)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lan lan = (Lan)o;
        if (this.id != lan.id) {
            return false;
        }
        if (this.segments != null ? !this.segments.equals(lan.segments) : lan.segments != null) {
            return false;
        }
        return this.name != null ? this.name.equals(lan.name) : lan.name == null;
    }

    public int hashCode() {
        int result = this.segments != null ? this.segments.hashCode() : 0;
        result = 31 * result + this.id;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(100);
        int count = 0;
        for (Segment segment : this.segments) {
            if (count++ > 0) {
                builder.append(';');
            }
            builder.append(segment.toString());
        }
        return builder.toString();
    }
}

