/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ping {
    public static final Pattern LINUX = Pattern.compile("icmp_seq=\\d+ ttl=\\d+ time=(.*?) ms");
    public static final Pattern WINDOWS = Pattern.compile("(bytes|\u5b57\u8282)=\\d+ (time|\u65f6\u95f4)=(.*?)ms TTL=\\d+");
    private static final Pattern WINDOWS_LESS = Pattern.compile("(bytes|\u5b57\u8282)=\\d+ (time|\u65f6\u95f4)<(.*?)ms TTL=\\d+");

    public static double ping(String ip, int count) throws IOException {
        return Ping.ping(ip, count, -1L, null);
    }

    public static double ping(String ip, int count, long interval) throws IOException {
        return Ping.ping(ip, count, interval, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double ping(String ip, int count, long interval, StringBuilder output) throws IOException {
        BufferedReader input = null;
        double result = 0.0;
        int success = 0;
        try {
            String text;
            String osName = System.getProperties().getProperty("os.name");
            String charset = System.getProperties().getProperty("sun.jnu.encoding");
            String pingCmd = null;
            boolean windows = osName.toUpperCase().startsWith("WINDOWS");
            if (windows) {
                pingCmd = "cmd /c ping -n {0} {1}";
                pingCmd = MessageFormat.format(pingCmd, count, ip);
            } else if (interval > 0L) {
                pingCmd = "ping -c {0} -i {1} {2}";
                pingCmd = MessageFormat.format(pingCmd, count, (double)interval * 1.0 / 1000.0, ip);
            } else {
                pingCmd = "ping -c {0} {1}";
                pingCmd = MessageFormat.format(pingCmd, count, ip);
            }
            Process process = Runtime.getRuntime().exec(pingCmd);
            input = new LineNumberReader(new InputStreamReader(process.getInputStream(), charset));
            int lines = 0;
            while ((text = ((LineNumberReader)input).readLine()) != null) {
                Matcher matcher;
                if (output != null) {
                    if (lines++ > 0) {
                        output.append('\n');
                    }
                    output.append(text);
                }
                if (text.isEmpty()) continue;
                if (windows) {
                    matcher = WINDOWS.matcher(text);
                    if (matcher.find()) {
                        ++success;
                        result += Double.valueOf(matcher.group(3)).doubleValue();
                        continue;
                    }
                    matcher = WINDOWS_LESS.matcher(text);
                    if (!matcher.find()) continue;
                    ++success;
                    result += Double.valueOf(matcher.group(3)).doubleValue();
                    continue;
                }
                matcher = LINUX.matcher(text);
                if (!matcher.find()) continue;
                ++success;
                result += Double.valueOf(matcher.group(1)).doubleValue();
            }
            if (success > 0) {
                double d = (double)Math.round(result * 100.0 / (double)success) / 100.0;
                return d;
            }
            double d = -1.0;
            return d;
        }
        finally {
            input.close();
        }
    }
}

