/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.os;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.Unsafe;

public abstract class Systems {
    public static final String USER_HOME = "user.home";
    public static final String OS_NAME = "os.name";
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final String JDOS_CPU = "JDOS_CPU";
    public static int CACHE_LINE_SIZE = 64;
    public static final Unsafe UNSAFE;
    protected static Long pid;
    protected static Pattern pattern;
    protected static final String userHome;
    protected static final String osName;
    protected static final String tmpDir;
    protected static final Memory memory;
    protected static final long BYTE_ARRAY_OFFSET;
    protected static final long SHORT_ARRAY_OFFSET;
    protected static final long SHORT_ARRAY_STRIDE;
    public static final boolean FAST_ACCESS_SUPPORTED;
    protected static final OSType osType;
    public static final boolean WINDOWS;
    public static final boolean SOLARIS;
    public static final boolean MAC;
    public static final boolean FREEBSD;
    public static final boolean LINUX;
    public static final boolean OTHER;
    public static final boolean PPC_64;
    public static CoresDetector[] coresDetectors;

    public static String getUserHome() {
        return userHome;
    }

    public static String getOsName() {
        return osName;
    }

    public static OSType getOsType() {
        return osType;
    }

    public static String getTmpDir() {
        return tmpDir;
    }

    public static long getPid() {
        if (pid != null) {
            return pid;
        }
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int indexOf = name.indexOf(64);
        if (indexOf > 0) {
            name = name.substring(0, indexOf);
        }
        pid = Long.parseLong(name);
        return pid;
    }

    public static int getCores() {
        for (CoresDetector detector : coresDetectors) {
            int cores = detector.getCores();
            if (cores == -1) continue;
            return cores;
        }
        return -1;
    }

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    public static int getCacheLineSize() {
        return CACHE_LINE_SIZE;
    }

    public static int getLongBytes() {
        return 8;
    }

    public static int getIntBytes() {
        return 4;
    }

    public static int getByte(byte[] data, int index) {
        return memory.getByte(data, index);
    }

    public static int getShort(short[] data, int index) {
        return memory.getShort(data, index);
    }

    public static int getInt(byte[] data, int index) {
        return memory.getInt(data, index);
    }

    public static long getLong(byte[] data, int index) {
        return memory.getLong(data, index);
    }

    public static void copyLong(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        memory.copyLong(src, srcIndex, dest, destIndex);
    }

    public static void copyMemory(byte[] src, int srcIndex, byte[] dest, int destIndex, int length) {
        memory.copyMemory(src, srcIndex, dest, destIndex, length);
    }

    static {
        pid = null;
        pattern = Pattern.compile("\"Cpuset\":\\s*\"(.*?)\"");
        userHome = System.getProperty(USER_HOME);
        osName = System.getProperty(OS_NAME);
        tmpDir = System.getProperty(JAVA_IO_TMPDIR);
        osType = osName.startsWith("Linux") ? OSType.LINUX : (osName.startsWith("Windows") ? OSType.WIN : (osName.contains("SunOS") || osName.contains("Solaris") ? OSType.SOLARIS : (osName.contains("Mac") ? OSType.MAC : (osName.contains("FreeBSD") ? OSType.FREEBSD : OSType.OTHER))));
        WINDOWS = osType == OSType.WIN;
        SOLARIS = osType == OSType.SOLARIS;
        MAC = osType == OSType.MAC;
        FREEBSD = osType == OSType.FREEBSD;
        LINUX = osType == OSType.LINUX;
        OTHER = osType == OSType.OTHER;
        PPC_64 = System.getProperties().getProperty("os.arch").contains("ppc64");
        coresDetectors = new CoresDetector[]{new JDOS1CoresDetector(), new JDOS2CoresDetector(), new DefaultCoresDetector()};
        try {
            PrivilegedExceptionAction<Unsafe> action = new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                    theUnsafe.setAccessible(true);
                    return (Unsafe)theUnsafe.get(null);
                }
            };
            UNSAFE = AccessController.doPrivileged(action);
            BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            SHORT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
            SHORT_ARRAY_STRIDE = UNSAFE.arrayIndexScale(short[].class);
            Memory target = null;
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                try {
                    UnsafeMemory unsafeMemory = new UnsafeMemory();
                    if (unsafeMemory.getInt(new byte[4], 0) == 0) {
                        target = unsafeMemory;
                    }
                }
                catch (Throwable unsafeMemory) {
                    // empty catch block
                }
            }
            if (target == null) {
                try {
                    SlowMemory slowMemory = new SlowMemory();
                    if (slowMemory.getInt(new byte[4], 0) != 0) {
                        throw new AssertionError((Object)"SlowMemory class is broken!");
                    }
                    target = slowMemory;
                }
                catch (Throwable ignored) {
                    throw new AssertionError((Object)"Could not find SlowMemory class");
                }
            }
            memory = target;
            FAST_ACCESS_SUPPORTED = memory.fastAccessSupported();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load unsafe", e);
        }
    }

    public static class DefaultCoresDetector
    implements CoresDetector {
        @Override
        public int getCores() {
            return Runtime.getRuntime().availableProcessors();
        }
    }

    public static class JDOS2CoresDetector
    implements CoresDetector {
        @Override
        public int getCores() {
            String value = System.getenv(Systems.JDOS_CPU);
            if (value != null && !value.isEmpty()) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    public static class JDOS1CoresDetector
    implements CoresDetector {
        public static String ETC_CONFIG_INFO = "/etc/config_info";

        @Override
        public int getCores() {
            Matcher matcher;
            String text;
            File file = new File(ETC_CONFIG_INFO);
            if (file.exists() && file.length() > 0L && (text = this.read(file)) != null && !text.isEmpty() && (matcher = pattern.matcher(text)).find()) {
                text = matcher.group(1);
                return text.split(",").length;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String read(File file) {
            String text = null;
            StringBuilder builder = new StringBuilder();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                int count = 0;
                while ((line = reader.readLine()) != null) {
                    if (count > 0) {
                        builder.append('\n');
                    }
                    builder.append(line);
                    ++count;
                }
                text = builder.toString();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return text;
        }
    }

    public static interface CoresDetector {
        public static final int UNKNOWN = -1;

        public int getCores();
    }

    static class UnsafeMemory
    implements Memory {
        UnsafeMemory() {
        }

        @Override
        public boolean fastAccessSupported() {
            return true;
        }

        @Override
        public int getShort(short[] data, int index) {
            assert (index >= 0);
            assert (index <= data.length);
            return UNSAFE.getShort(data, SHORT_ARRAY_OFFSET + (long)index * SHORT_ARRAY_STRIDE) & 0xFFFF;
        }

        @Override
        public int getByte(byte[] data, int index) {
            assert (index >= 0);
            assert (index <= data.length);
            return UNSAFE.getByte(data, BYTE_ARRAY_OFFSET + (long)index) & 0xFF;
        }

        @Override
        public int getInt(byte[] data, int index) {
            assert (index >= 0);
            assert (index + 4 <= data.length);
            return UNSAFE.getInt(data, BYTE_ARRAY_OFFSET + (long)index);
        }

        @Override
        public void copyLong(byte[] src, int srcIndex, byte[] dest, int destIndex) {
            assert (srcIndex >= 0);
            assert (srcIndex + 8 <= src.length);
            assert (destIndex >= 0);
            assert (destIndex + 8 <= dest.length);
            long value = UNSAFE.getLong(src, BYTE_ARRAY_OFFSET + (long)srcIndex);
            UNSAFE.putLong(dest, BYTE_ARRAY_OFFSET + (long)destIndex, value);
        }

        @Override
        public long getLong(byte[] data, int index) {
            assert (index > 0);
            assert (index + 4 < data.length);
            return UNSAFE.getLong(data, BYTE_ARRAY_OFFSET + (long)index);
        }

        @Override
        public void copyMemory(byte[] src, int srcIndex, byte[] dest, int destIndex, int length) {
            assert (srcIndex >= 0);
            assert (srcIndex + length <= src.length);
            assert (destIndex >= 0);
            assert (destIndex + length <= dest.length);
            UNSAFE.copyMemory(src, BYTE_ARRAY_OFFSET + (long)srcIndex, dest, BYTE_ARRAY_OFFSET + (long)destIndex, length);
        }
    }

    static class SlowMemory
    implements Memory {
        SlowMemory() {
        }

        @Override
        public boolean fastAccessSupported() {
            return false;
        }

        @Override
        public int getShort(short[] data, int index) {
            return data[index] & 0xFFFF;
        }

        @Override
        public int getByte(byte[] data, int index) {
            return data[index] & 0xFF;
        }

        @Override
        public int getInt(byte[] data, int index) {
            return data[index] & 0xFF | (data[index + 1] & 0xFF) << 8 | (data[index + 2] & 0xFF) << 16 | (data[index + 3] & 0xFF) << 24;
        }

        @Override
        public void copyLong(byte[] src, int srcIndex, byte[] dest, int destIndex) {
            for (int i = 0; i < 8; ++i) {
                dest[destIndex + i] = src[srcIndex + i];
            }
        }

        @Override
        public long getLong(byte[] data, int index) {
            return (long)data[index] & 0xFFL | ((long)data[index + 1] & 0xFFL) << 8 | ((long)data[index + 2] & 0xFFL) << 16 | ((long)data[index + 3] & 0xFFL) << 24 | ((long)data[index + 4] & 0xFFL) << 32 | ((long)data[index + 5] & 0xFFL) << 40 | ((long)data[index + 6] & 0xFFL) << 48 | ((long)data[index + 7] & 0xFFL) << 56;
        }

        @Override
        public void copyMemory(byte[] src, int srcIndex, byte[] dest, int destIndex, int length) {
            System.arraycopy(src, srcIndex, dest, destIndex, length);
        }
    }

    static interface Memory {
        public boolean fastAccessSupported();

        public int getByte(byte[] var1, int var2);

        public int getShort(short[] var1, int var2);

        public int getInt(byte[] var1, int var2);

        public long getLong(byte[] var1, int var2);

        public void copyLong(byte[] var1, int var2, byte[] var3, int var4);

        public void copyMemory(byte[] var1, int var2, byte[] var3, int var4, int var5);
    }

    public static enum OSType {
        LINUX,
        WIN,
        SOLARIS,
        MAC,
        FREEBSD,
        OTHER;

    }
}

