/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.toolkit.reflect.ReflectException;

public class Reflect {
    private static ConcurrentMap<Field, FieldAccessor> accessors = new ConcurrentHashMap<Field, FieldAccessor>();

    public static FieldAccessor getAccessor(Field field) {
        FieldAccessor exists;
        if (field == null) {
            return null;
        }
        FieldAccessor accessor = (FieldAccessor)accessors.get(field);
        if (accessor == null && (exists = accessors.putIfAbsent(field, accessor = new FieldAccessor(field))) != null) {
            accessor = exists;
        }
        return accessor;
    }

    public static void set(Field field, Object target, Object value) throws ReflectException {
        if (field == null || target == null) {
            return;
        }
        FieldAccessor accessor = Reflect.getAccessor(field);
        if (accessor != null) {
            accessor.set(target, value);
        }
    }

    public static Object get(Field field, Object target) throws ReflectException {
        if (field == null || target == null) {
            return null;
        }
        FieldAccessor accessor = Reflect.getAccessor(field);
        if (accessor != null) {
            return accessor.get(target);
        }
        return null;
    }

    public static int size(Class<?> type, Object value) {
        if (type == null || value == null) {
            return 0;
        }
        int size = 0;
        if (type.isArray()) {
            size = Array.getLength(value);
        } else if (CharSequence.class.isAssignableFrom(type)) {
            size = ((CharSequence)value).length();
        } else if (Collection.class.isAssignableFrom(type)) {
            size = ((Collection)value).size();
        } else if (Map.class.isAssignableFrom(type)) {
            size = ((Map)value).size();
        }
        return size;
    }

    public static class FieldAccessor {
        private Field field;
        private Method getter;
        private Method setter;

        public FieldAccessor(Field field) {
            if (field == null) {
                throw new IllegalArgumentException("field can not be null.");
            }
            this.field = field;
            Class<?> clazz = field.getDeclaringClass();
            if (clazz != null) {
                Method[] methods;
                String name = field.getName();
                char[] data = name.toCharArray();
                data[0] = Character.toUpperCase(data[0]);
                name = new String(data);
                String getName = "get" + name;
                String getBoolName = "is" + name;
                String setName = "set" + name;
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    Class<?>[] types;
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    name = method.getName();
                    if (name.equals(getName) || name.equals(getBoolName)) {
                        types = method.getParameterTypes();
                        if (types != null && types.length != 0) continue;
                        this.getter = method;
                        continue;
                    }
                    if (!name.equals(setName) || (types = method.getParameterTypes()) == null || types.length != 1 || types[0] != field.getType()) continue;
                    this.setter = method;
                }
            }
        }

        public Field getField() {
            return this.field;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public Object get(Object target) throws ReflectException {
            if (target == null) {
                return null;
            }
            if (this.getter != null) {
                return this.getter.invoke(target, new Object[0]);
            }
            if (this.field.isAccessible()) {
                return this.field.get(target);
            }
            this.field.setAccessible(true);
            try {
                Object object = this.field.get(target);
                this.field.setAccessible(false);
                return object;
            }
            catch (Throwable throwable) {
                try {
                    this.field.setAccessible(false);
                    throw throwable;
                }
                catch (IllegalAccessException e) {
                    throw new ReflectException(e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectException(e.getMessage(), e.getCause() != null ? e.getCause() : e);
                }
            }
        }

        public void set(Object target, Object value) throws ReflectException {
            block9: {
                try {
                    if (target == null) {
                        return;
                    }
                    if (this.setter != null) {
                        this.setter.invoke(target, value);
                        break block9;
                    }
                    if (this.field.isAccessible()) {
                        this.field.set(target, value);
                        break block9;
                    }
                    this.field.setAccessible(true);
                    try {
                        this.field.set(target, value);
                    }
                    finally {
                        this.field.setAccessible(false);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new ReflectException(e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectException(e.getMessage(), e.getCause() != null ? e.getCause() : e);
                }
            }
        }
    }
}

