/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.security;

public abstract class Hex {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final String encode(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        char[] str = new char[data.length * 2];
        int k = 0;
        for (byte b : data) {
            str[k++] = HEX[b >>> 4 & 0xF];
            str[k++] = HEX[b & 0xF];
        }
        return new String(str);
    }

    public static final byte[] decode(String data) {
        if (data == null) {
            return null;
        }
        if (data.isEmpty()) {
            return new byte[0];
        }
        int length = data.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("length must be a power of 2");
        }
        int size = length >> 1;
        byte[] result = new byte[size];
        char[] chars = data.toCharArray();
        int i = 0;
        for (char ch : chars) {
            int value;
            switch (ch) {
                case '0': {
                    value = 0;
                    break;
                }
                case '1': {
                    value = 1;
                    break;
                }
                case '2': {
                    value = 2;
                    break;
                }
                case '3': {
                    value = 3;
                    break;
                }
                case '4': {
                    value = 4;
                    break;
                }
                case '5': {
                    value = 5;
                    break;
                }
                case '6': {
                    value = 6;
                    break;
                }
                case '7': {
                    value = 7;
                    break;
                }
                case '8': {
                    value = 8;
                    break;
                }
                case '9': {
                    value = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    value = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    value = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    value = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    value = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    value = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    value = 15;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid hex string");
                }
            }
            int pos = i >> 1;
            result[pos] = (i & 1) == 0 ? value : (byte)(result[pos] << 4 | value);
            ++i;
        }
        return result;
    }
}

