/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.stat;

import java.io.Serializable;

public class TPStat
implements Serializable {
    private int tp999;
    private int tp99;
    private int tp90;
    private int tp50;
    private int max;
    private int min;
    private long success;
    private long error;
    private long count;
    private long size;
    private long time;

    public TPStat() {
    }

    public TPStat(long count, long success, long error, long size, long time) {
        this.count = count;
        this.success = success;
        this.error = error;
        this.size = size;
        this.time = time;
    }

    public int getTp999() {
        return this.tp999;
    }

    public void setTp999(int tp999) {
        this.tp999 = tp999;
    }

    public int getTp99() {
        return this.tp99;
    }

    public void setTp99(int tp99) {
        this.tp99 = tp99;
    }

    public int getTp90() {
        return this.tp90;
    }

    public void setTp90(int tp90) {
        this.tp90 = tp90;
    }

    public int getTp50() {
        return this.tp50;
    }

    public void setTp50(int tp50) {
        this.tp50 = tp50;
    }

    public int getAvg() {
        return this.success <= 0L ? 0 : (int)Math.ceil((double)this.time * 1.0 / (double)this.success);
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getSuccess() {
        return this.success;
    }

    public void setSuccess(long success) {
        this.success = success;
    }

    public long getError() {
        return this.error;
    }

    public void setError(long error) {
        this.error = error;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public double getRatio() {
        return this.error <= 0L ? 100.0 : (double)((long)((double)this.success * 1.0 / (double)(this.success + this.error) * 10000.0)) / 100.0;
    }

    public long getTps() {
        return this.success <= 0L ? 0L : (this.time <= 0L ? this.success * 1000L : this.success * 1000L / this.time);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        sb.append("\"tp999\":").append(this.tp999);
        sb.append(", \"tp99\":").append(this.tp99);
        sb.append(", \"tp90\":").append(this.tp90);
        sb.append(", \"tp50\":").append(this.tp50);
        sb.append(", \"avg\":").append(this.getAvg());
        sb.append(", \"max\":").append(this.max);
        sb.append(", \"min\":").append(this.min);
        sb.append(", \"count\":").append(this.success);
        sb.append(", \"error\":").append(this.error);
        sb.append(", \"size\":").append(this.size);
        sb.append(", \"time\":").append(this.time);
        sb.append(", \"ratio\":").append(this.getRatio());
        sb.append('}');
        return sb.toString();
    }
}

