/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.stat;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.joyqueue.toolkit.stat.TPStatSlice;
import org.joyqueue.toolkit.time.SystemClock;

public class TPStatDoubleBuffer<T extends TPStatSlice> {
    protected T readStat;
    protected T writeStat;
    protected long interval;
    protected long lastTime;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public TPStatDoubleBuffer(T readStat, T writeStat) {
        this(readStat, writeStat, 0L);
    }

    public TPStatDoubleBuffer(T readStat, T writeStat, long interval) {
        this.readStat = readStat;
        this.writeStat = writeStat;
        this.interval = interval;
    }

    public T slice() {
        if (!this.isExpire()) {
            return this.readStat;
        }
        this.lock.writeLock().lock();
        try {
            if (!this.isExpire()) {
                T t = this.readStat;
                return t;
            }
            T stat = this.writeStat;
            this.writeStat = this.readStat;
            this.readStat = stat;
            if (this.writeStat != null) {
                this.writeStat.clear();
                this.writeStat.getPeriod().begin();
            }
            this.lastTime = SystemClock.now();
            T t = this.readStat;
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected boolean isExpire() {
        return this.interval <= 0L || this.lastTime <= 0L && SystemClock.now() - this.lastTime > this.interval;
    }
}

