/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTime {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String UTC_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    protected final Calendar calendar;

    protected DateTime(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("calendar can not be null");
        }
        this.calendar = calendar;
    }

    public static DateTime of() {
        return new DateTime(Calendar.getInstance());
    }

    public static DateTime of(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("calendar can not be null");
        }
        return new DateTime(calendar);
    }

    public static DateTime of(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date can not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new DateTime(calendar);
    }

    public static DateTime of(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return new DateTime(calendar);
    }

    public static DateTime of(String time, String format) {
        if (format == null || format.isEmpty()) {
            throw new IllegalArgumentException("format can not be empty");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return DateTime.of(time, sdf);
    }

    public static DateTime of(String time, SimpleDateFormat format) {
        if (time == null || time.isEmpty()) {
            throw new IllegalArgumentException("time can not be empty");
        }
        if (format == null) {
            throw new IllegalArgumentException("format can not be null");
        }
        try {
            Date date = format.parse(time);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return new DateTime(calendar);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("invalid time %s or format %s.", time, format), e);
        }
    }

    public DateTime addYear(int year) {
        this.calendar.add(1, year);
        return this;
    }

    public DateTime addMonth(int month) {
        this.calendar.add(2, month);
        return this;
    }

    public DateTime addDay(int day) {
        this.calendar.add(6, day);
        return this;
    }

    public DateTime addHour(int hour) {
        this.calendar.add(11, hour);
        return this;
    }

    public DateTime addMinute(int minute) {
        this.calendar.add(12, minute);
        return this;
    }

    public DateTime addMillisecond(int millisecond) {
        this.calendar.add(14, millisecond);
        return this;
    }

    public DateTime year(int year) {
        this.calendar.set(1, year);
        return this;
    }

    public DateTime month(int month) {
        this.calendar.set(2, month);
        return this;
    }

    public DateTime dayOfYear(int day) {
        this.calendar.set(6, day);
        return this;
    }

    public DateTime dayOfMonth(int day) {
        this.calendar.set(5, day);
        return this;
    }

    public DateTime dayOfWeak(int day) {
        this.calendar.set(7, day);
        return this;
    }

    public DateTime hour(int hour) {
        this.calendar.set(11, hour);
        return this;
    }

    public DateTime minute(int minute) {
        this.calendar.set(12, minute);
        return this;
    }

    public DateTime second(int second) {
        this.calendar.set(13, second);
        return this;
    }

    public DateTime time(long time) {
        this.calendar.setTimeInMillis(time);
        return this;
    }

    public int year() {
        return this.calendar.get(1);
    }

    public int month() {
        return this.calendar.get(2);
    }

    public int dayOfWeek() {
        return this.calendar.get(7);
    }

    public int dayOfMonth() {
        if (this.calendar == null) {
            throw new IllegalArgumentException("calendar can not be null");
        }
        return this.calendar.get(5);
    }

    public int dayOfYear() {
        return this.calendar.get(6);
    }

    public int hour() {
        return this.calendar.get(11);
    }

    public int minute() {
        return this.calendar.get(12);
    }

    public int second() {
        return this.calendar.get(13);
    }

    public long time() {
        return this.calendar.getTimeInMillis();
    }

    public Date date() {
        return this.calendar.getTime();
    }

    public DateTime date(Date date) {
        this.calendar.setTime(date);
        return this;
    }

    public Calendar calendar() {
        return this.calendar;
    }

    public DateTime beginOfDay() {
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this;
    }

    public DateTime beginOfHour() {
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this;
    }

    public DateTime beginOfMinute() {
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this;
    }

    public DateTime endOfDay() {
        this.calendar.set(11, 23);
        this.calendar.set(12, 59);
        this.calendar.set(13, 59);
        this.calendar.set(14, 999);
        return this;
    }

    public DateTime endOfHour() {
        if (this.calendar == null) {
            throw new IllegalArgumentException("calendar can not be null");
        }
        this.calendar.set(12, 59);
        this.calendar.set(13, 59);
        this.calendar.set(14, 999);
        return this;
    }

    public DateTime endOfMinute() {
        this.calendar.set(13, 59);
        this.calendar.set(14, 999);
        return this;
    }

    public boolean after(DateTime target) {
        if (target == null) {
            return false;
        }
        return this.time() > target.time();
    }

    public boolean ge(DateTime target) {
        if (target == null) {
            return false;
        }
        return this.time() >= target.time();
    }

    public boolean before(DateTime target) {
        if (target == null) {
            return false;
        }
        return this.time() < target.time();
    }

    public boolean le(DateTime target) {
        if (target == null) {
            return false;
        }
        return this.time() <= target.time();
    }

    public String toString(String format) {
        if (format == null || format.isEmpty()) {
            throw new IllegalArgumentException("format can not be empty");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(this.calendar.getTime());
    }

    public String toString(SimpleDateFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("format can not be null");
        }
        return format.format(this.calendar.getTime());
    }

    public String toString() {
        return this.toString(YYYY_MM_DD_HH_MM_SS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTime dateTime = (DateTime)o;
        return this.calendar.equals(dateTime.calendar);
    }

    public int hashCode() {
        return this.calendar.hashCode();
    }
}

