/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.time;

import java.util.concurrent.TimeUnit;
import org.joyqueue.toolkit.time.Period;

public class MicroPeriod
implements Period {
    protected long startTime;
    protected long endTime;

    @Override
    public void begin() {
        this.startTime = System.nanoTime();
    }

    @Override
    public void end() {
        this.endTime = System.nanoTime();
    }

    @Override
    public long time() {
        return TimeUnit.NANOSECONDS.toMicros(this.endTime - this.startTime);
    }

    @Override
    public void clear() {
        this.startTime = 0L;
        this.endTime = 0L;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return TimeUnit.MICROSECONDS;
    }
}

