/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.time;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SystemClock {
    private static final SystemClock instance = new SystemClock();
    private final long precision;
    private final AtomicLong now;
    private ScheduledExecutorService scheduler;

    public static SystemClock getInstance() {
        return instance;
    }

    public SystemClock() {
        this(1L);
    }

    public SystemClock(long precision) {
        this.precision = precision;
        this.now = new AtomicLong(System.currentTimeMillis());
        this.scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "SystemClock");
            thread.setDaemon(true);
            return thread;
        });
        this.scheduler.scheduleAtFixedRate(new Timer(this.now), precision, precision, TimeUnit.MILLISECONDS);
    }

    public long getTime() {
        return this.now.get();
    }

    public static long now() {
        return instance.getTime();
    }

    public long precision() {
        return this.precision;
    }

    protected static class Timer
    implements Runnable {
        private final AtomicLong now;

        private Timer(AtomicLong now) {
            this.now = now;
        }

        @Override
        public void run() {
            this.now.set(System.currentTimeMillis());
        }
    }
}

