/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.util;

import java.io.File;
import java.io.IOException;

public class BaseDirUtils {
    public static File prepareBaseDir(String basePath) throws IOException {
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        File tempDirFile = new File(tempDir);
        assert (tempDirFile.exists() && tempDirFile.isDirectory() && tempDirFile.canWrite());
        File base = new File(basePath);
        if (base.exists()) {
            if (base.isDirectory()) {
                BaseDirUtils.deleteFolder(base);
            } else {
                base.delete();
            }
        }
        base.mkdirs();
        return base;
    }

    public static File prepareBaseDir() throws IOException {
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        return BaseDirUtils.prepareBaseDir(tempDir + File.separator + "joyqueuedata");
    }

    public static void destroyBaseDir() {
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        BaseDirUtils.destroyBaseDir(new File(tempDir + File.separator + "joyqueuedata"));
    }

    public static void destroyBaseDir(File base) {
        if (base.exists()) {
            if (base.isDirectory()) {
                BaseDirUtils.deleteFolder(base);
            } else {
                base.delete();
            }
        }
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    BaseDirUtils.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }
}

