/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.validate;

import java.lang.annotation.Annotation;
import org.joyqueue.toolkit.reflect.Reflect;
import org.joyqueue.toolkit.validate.ValidateException;
import org.joyqueue.toolkit.validate.Validator;
import org.joyqueue.toolkit.validate.annotation.NotEmpty;

public class NotEmptyValidator
implements Validator {
    public static final NotEmptyValidator INSTANCE = new NotEmptyValidator();

    @Override
    public void validate(Object target, Annotation annotation, Validator.Value value) throws ValidateException {
        NotEmpty notEmpty = (NotEmpty)annotation;
        int size = Reflect.size(value.type, value.value);
        if (size == 0) {
            if (notEmpty.message() == null || notEmpty.message().isEmpty()) {
                throw new ValidateException(String.format("%s must not be empty.", value.name));
            }
            throw new ValidateException(String.format(notEmpty.message(), value.name));
        }
    }
}

