/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.validate;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import org.joyqueue.toolkit.validate.ValidateException;
import org.joyqueue.toolkit.validate.Validator;
import org.joyqueue.toolkit.validate.annotation.Pattern;

public class PatternValidator
implements Validator {
    public static final PatternValidator INSTANCE = new PatternValidator();
    protected ConcurrentMap<String, java.util.regex.Pattern> patterns = new ConcurrentHashMap<String, java.util.regex.Pattern>();

    @Override
    public void validate(Object target, Annotation annotation, Validator.Value value) throws ValidateException {
        Matcher matcher;
        Pattern pattern = (Pattern)annotation;
        String v = value.value == null ? "" : value.value.toString();
        java.util.regex.Pattern p = (java.util.regex.Pattern)this.patterns.get(v);
        if (p == null) {
            p = java.util.regex.Pattern.compile(v);
            this.patterns.putIfAbsent(v, p);
        }
        if ((matcher = p.matcher(v)).find() == pattern.flag()) {
            if (pattern.message() == null || pattern.message().isEmpty()) {
                throw new ValidateException(String.format("%s is not match with %s.", value.name, v));
            }
            throw new ValidateException(String.format(pattern.message(), value.name, v));
        }
    }
}

