/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.validate;

import java.lang.annotation.Annotation;
import org.joyqueue.toolkit.reflect.Reflect;
import org.joyqueue.toolkit.validate.ValidateException;
import org.joyqueue.toolkit.validate.Validator;
import org.joyqueue.toolkit.validate.annotation.Size;

public class SizeValidator
implements Validator {
    public static final SizeValidator INSTANCE = new SizeValidator();

    @Override
    public void validate(Object target, Annotation annotation, Validator.Value value) throws ValidateException {
        Size size = (Size)annotation;
        int length = Reflect.size(value.type, value.value);
        if (length < size.min() || length > size.max()) {
            if (size.message() == null || size.message().isEmpty()) {
                throw new ValidateException(String.format("%s length must between %d and %d.", value.name, size.min(), size.max()));
            }
            throw new ValidateException(String.format(size.message(), value.name, size.min(), size.max()));
        }
    }
}

