/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.joyqueue.toolkit.validate.ValidateException;
import org.joyqueue.toolkit.validate.Validator;
import org.joyqueue.toolkit.validate.Validators;

public class ValidValidator
implements Validator {
    public static final ValidValidator INSTANCE = new ValidValidator();

    @Override
    public void validate(Object target, Annotation annotation, Validator.Value value) throws ValidateException {
        if (value.value == null) {
            return;
        }
        Class<?> type = value.type;
        if (!this.isSupported(type)) {
            return;
        }
        if (type.isArray()) {
            int length = Array.getLength(value.value);
            for (int i = 0; i < length; ++i) {
                Object obj = Array.get(value.value, i);
                if (obj == null || !this.isSupported(obj.getClass())) continue;
                Validators.validate(obj);
            }
        } else if (Collection.class.isAssignableFrom(type)) {
            for (Object obj : (Collection)value.value) {
                if (obj == null || !this.isSupported(obj.getClass())) continue;
                Validators.validate(obj);
            }
        } else {
            Validators.validate(value.value);
        }
    }

    protected boolean isSupported(Class type) {
        if (type == Integer.TYPE) {
            return false;
        }
        if (type == Long.TYPE) {
            return false;
        }
        if (type == Double.TYPE) {
            return false;
        }
        if (type == Short.TYPE) {
            return false;
        }
        if (type == Byte.TYPE) {
            return false;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (Number.class.isAssignableFrom(type)) {
            return false;
        }
        if (type == Boolean.class) {
            return false;
        }
        if (type == String.class) {
            return false;
        }
        if (type == Object.class) {
            return false;
        }
        if (Date.class.isAssignableFrom(type)) {
            return false;
        }
        return !Map.class.isAssignableFrom(type);
    }
}

