/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.ValidationException;
import org.joyqueue.toolkit.lang.Getter;
import org.joyqueue.toolkit.lang.Getters;
import org.joyqueue.toolkit.reflect.ReflectException;
import org.joyqueue.toolkit.validate.DoubleRangeValidator;
import org.joyqueue.toolkit.validate.NotEmptyValidator;
import org.joyqueue.toolkit.validate.NotNullValidator;
import org.joyqueue.toolkit.validate.PatternValidator;
import org.joyqueue.toolkit.validate.RangeValidator;
import org.joyqueue.toolkit.validate.SizeValidator;
import org.joyqueue.toolkit.validate.ValidValidator;
import org.joyqueue.toolkit.validate.ValidateException;
import org.joyqueue.toolkit.validate.Validator;
import org.joyqueue.toolkit.validate.annotation.DoubleRange;
import org.joyqueue.toolkit.validate.annotation.NotEmpty;
import org.joyqueue.toolkit.validate.annotation.NotNull;
import org.joyqueue.toolkit.validate.annotation.Pattern;
import org.joyqueue.toolkit.validate.annotation.Range;
import org.joyqueue.toolkit.validate.annotation.Size;
import org.joyqueue.toolkit.validate.annotation.Valid;

public class Validators {
    private static ConcurrentMap<Method, MethodValidation> validations = new ConcurrentHashMap<Method, MethodValidation>();

    public static void validate(Object target) throws ValidateException {
        if (target == null) {
            return;
        }
        for (Class<?> clazz = target.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Getter getter = null;
                Annotation[] annotations = field.getDeclaredAnnotations();
                if (annotations == null) continue;
                for (Annotation annotation : annotations) {
                    Validator validator = Validators.getValidator(annotation);
                    if (validator == null) continue;
                    if (getter == null) {
                        getter = Getters.field(field, target, true);
                    }
                    try {
                        validator.validate(target, annotation, new Validator.Value(field.getName(), field.getType(), getter.get()));
                    }
                    catch (ReflectException e) {
                        throw new ValidateException(e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected static Validator getValidator(Annotation annotation) {
        Validator validator = null;
        if (annotation instanceof NotNull) {
            validator = NotNullValidator.INSTANCE;
        } else if (annotation instanceof NotEmpty) {
            validator = NotEmptyValidator.INSTANCE;
        } else if (annotation instanceof Size) {
            validator = SizeValidator.INSTANCE;
        } else if (annotation instanceof Range) {
            validator = RangeValidator.INSTANCE;
        } else if (annotation instanceof DoubleRange) {
            validator = DoubleRangeValidator.INSTANCE;
        } else if (annotation instanceof Pattern) {
            validator = PatternValidator.INSTANCE;
        } else if (annotation instanceof Valid) {
            validator = ValidValidator.INSTANCE;
        }
        return validator;
    }

    public static void validate(Method method, Object target, Object ... arguments) throws ValidationException {
        if (method == null || target == null || arguments == null || arguments.length == 0) {
            return;
        }
        MethodValidation valid = Validators.getMethodValidation(method, target);
        if (valid != null && valid.validation != null) {
            for (int i = 0; i < valid.types.length; ++i) {
                if (valid.annotations[i] == null) continue;
                for (Annotation annotation : valid.annotations[i]) {
                    Validator validator = Validators.getValidator(annotation);
                    if (validator == null) continue;
                    validator.validate(target, annotation, new Validator.Value(valid.names[i], valid.types[i], arguments[i]));
                }
            }
        }
    }

    protected static MethodValidation getMethodValidation(Method method, Object target) {
        MethodValidation cache = (MethodValidation)validations.get(method);
        if (cache == null) {
            Valid validation = method.getAnnotation(Valid.class);
            if (validation == null && Modifier.isAbstract(method.getModifiers())) {
                try {
                    Class<?> aClass = target.getClass();
                    Method implMethod = aClass.getMethod(method.getName(), method.getParameterTypes());
                    validation = implMethod.getAnnotation(Valid.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            cache = new MethodValidation(validation, method.getParameterAnnotations(), method.getParameterTypes());
            validations.putIfAbsent(method, cache);
        }
        return cache;
    }

    protected static class MethodValidation {
        protected Valid validation;
        protected Annotation[][] annotations;
        protected Class<?>[] types;
        protected String[] names;

        public MethodValidation(Valid validation, Annotation[][] annotations, Class<?>[] types) {
            this.validation = validation;
            this.annotations = annotations;
            this.types = types;
            this.names = new String[types.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = "arg" + i;
            }
        }

        public MethodValidation(Valid validation, Annotation[][] annotations, Class<?>[] types, String[] names) {
            this.validation = validation;
            this.annotations = annotations;
            this.types = types;
            this.names = names;
        }
    }
}

