/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.vm;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.joyqueue.toolkit.vm.GCEvent;
import org.joyqueue.toolkit.vm.GCEventListener;
import org.joyqueue.toolkit.vm.GCEventType;
import org.joyqueue.toolkit.vm.JVMMemorySectionInfo;

public class DefaultGCNotificationParser
implements NotificationListener {
    private List<GCEventListener> gcListeners = new ArrayList<GCEventListener>();

    public void addListener(GCEventListener listener) {
        this.gcListeners.add(listener);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("com.sun.management.gc.notification")) {
            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
            GCEvent event = new GCEvent();
            event.setGcInfo(info);
            event.setType(GCEventType.typeOf(info.getGcAction()));
            event.setMemorySections(new HashMap<String, JVMMemorySectionInfo>());
            Map<String, MemoryUsage> beforeGc = info.getGcInfo().getMemoryUsageBeforeGc();
            Map<String, MemoryUsage> afterGc = info.getGcInfo().getMemoryUsageAfterGc();
            for (Map.Entry<String, MemoryUsage> entry : afterGc.entrySet()) {
                String name = entry.getKey();
                MemoryUsage after = entry.getValue();
                MemoryUsage before = beforeGc.get(name);
                JVMMemorySectionInfo memoryInfo = new JVMMemorySectionInfo();
                memoryInfo.setName(name);
                memoryInfo.setAfter(after);
                memoryInfo.setBefore(before);
                event.getMemorySections().put(name, memoryInfo);
            }
            for (GCEventListener listener : this.gcListeners) {
                listener.handleNotification(event);
            }
        } else {
            System.out.println(notification.getType() + " ignore");
        }
    }
}

