/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.buffer;

import java.io.Closeable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joyqueue.toolkit.ref.Reference;
import org.joyqueue.toolkit.ref.ReferenceCounter;

public class RByteBuffer
implements Closeable {
    protected ByteBuffer buffer;
    protected Reference reference;
    protected AtomicBoolean released = new AtomicBoolean(false);

    public RByteBuffer(ByteBuffer buffer, Reference reference) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer can not be null");
        }
        this.buffer = buffer;
        this.reference = reference == null ? new ReferenceCounter() : reference;
        this.reference.acquire();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public Reference getReference() {
        return this.reference;
    }

    public final int capacity() {
        return this.buffer.capacity();
    }

    public final int position() {
        return this.buffer.position();
    }

    public final Buffer position(int newPosition) {
        return this.buffer.position(newPosition);
    }

    public final int limit() {
        return this.buffer.limit();
    }

    public final Buffer limit(int newLimit) {
        return this.buffer.limit(newLimit);
    }

    public final Buffer mark() {
        return this.buffer.mark();
    }

    public final Buffer reset() {
        return this.buffer.reset();
    }

    public final Buffer clear() {
        return this.buffer.clear();
    }

    public final Buffer flip() {
        return this.buffer.flip();
    }

    public final Buffer rewind() {
        return this.buffer.rewind();
    }

    public final int remaining() {
        return this.buffer.remaining();
    }

    public final boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public final boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    public final boolean hasArray() {
        return this.buffer.hasArray();
    }

    public final int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public final boolean isDirect() {
        return this.buffer.isDirect();
    }

    public final ByteBuffer slice() {
        return this.buffer.slice();
    }

    public final byte get() {
        return this.buffer.get();
    }

    public final ByteBuffer put(byte b) {
        return this.buffer.put(b);
    }

    public final byte get(int index) {
        return this.buffer.get(index);
    }

    public final ByteBuffer put(int index, byte b) {
        return this.buffer.put(index, b);
    }

    public final ByteBuffer get(byte[] dst, int offset, int length) {
        return this.buffer.get(dst, offset, length);
    }

    public final ByteBuffer get(byte[] dst) {
        return this.buffer.get(dst);
    }

    public final ByteBuffer put(ByteBuffer src) {
        return this.buffer.put(src);
    }

    public final ByteBuffer put(byte[] src, int offset, int length) {
        return this.buffer.put(src, offset, length);
    }

    public final ByteBuffer put(byte[] src) {
        return this.buffer.put(src, 0, src.length);
    }

    public final byte[] array() {
        return this.buffer.array();
    }

    public final ByteBuffer compact() {
        return this.buffer.compact();
    }

    public final char getChar() {
        return this.buffer.getChar();
    }

    public final ByteBuffer putChar(char value) {
        return this.buffer.putChar(value);
    }

    public final char getChar(int index) {
        return this.buffer.getChar(index);
    }

    public final ByteBuffer putChar(int index, char value) {
        return this.buffer.putChar(index, value);
    }

    public final short getShort() {
        return this.buffer.getShort();
    }

    public final ByteBuffer putShort(short value) {
        return this.buffer.putShort(value);
    }

    public final short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public final ByteBuffer putShort(int index, short value) {
        return this.buffer.putShort(index, value);
    }

    public final int getInt() {
        return this.buffer.getInt();
    }

    public final ByteBuffer putInt(int value) {
        return this.buffer.putInt(value);
    }

    public final int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public final ByteBuffer putInt(int index, int value) {
        return this.buffer.putInt(index, value);
    }

    public final long getLong() {
        return this.buffer.getLong();
    }

    public final ByteBuffer putLong(long value) {
        return this.buffer.putLong(value);
    }

    public final long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public final ByteBuffer putLong(int index, long value) {
        return this.buffer.putLong(index, value);
    }

    public final float getFloat() {
        return this.buffer.getFloat();
    }

    public final ByteBuffer putFloat(float value) {
        return this.buffer.putFloat(value);
    }

    public final float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    public final ByteBuffer putFloat(int index, float value) {
        return this.buffer.putFloat(index, value);
    }

    public final double getDouble() {
        return this.buffer.getDouble();
    }

    public final ByteBuffer putDouble(double value) {
        return this.buffer.putDouble(value);
    }

    public final double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    public final ByteBuffer putDouble(int index, double value) {
        return this.buffer.putDouble(index, value);
    }

    public final boolean release() {
        if (this.released.compareAndSet(false, true)) {
            return this.reference.release();
        }
        return false;
    }

    @Override
    public void close() {
        this.release();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RByteBuffer that = (RByteBuffer)o;
        if (this.buffer != null ? !this.buffer.equals(that.buffer) : that.buffer != null) {
            return false;
        }
        return this.reference != null ? this.reference.equals(that.reference) : that.reference == null;
    }

    public int hashCode() {
        int result = this.buffer != null ? this.buffer.hashCode() : 0;
        result = 31 * result + (this.reference != null ? this.reference.hashCode() : 0);
        return result;
    }
}

