/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.concurrent;

import java.util.ConcurrentModificationException;
import java.util.concurrent.atomic.AtomicLong;

public class CasLock {
    private static final long FREE = -1L;
    private final AtomicLong lockThread = new AtomicLong(-1L);
    private final AtomicLong references = new AtomicLong(0L);

    public void waitAndLock() {
        while (!this.tryLock()) {
            Thread.yield();
        }
    }

    public void checkLock() {
        long thread = Thread.currentThread().getId();
        if (thread != this.lockThread.get() && !this.lockThread.compareAndSet(-1L, thread)) {
            throw new ConcurrentModificationException();
        }
        this.references.getAndIncrement();
    }

    public boolean tryLock() {
        long thread = Thread.currentThread().getId();
        if (thread != this.lockThread.get() && !this.lockThread.compareAndSet(-1L, thread)) {
            return false;
        }
        this.references.getAndIncrement();
        return true;
    }

    public void unlock() {
        long thread = Thread.currentThread().getId();
        if (thread == this.lockThread.get() && this.references.decrementAndGet() == 0L) {
            this.lockThread.set(-1L);
        }
    }
}

