/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.concurrent;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joyqueue.toolkit.concurrent.EventListener;

public class EventFuture<R>
implements Future<R>,
EventListener<R> {
    private R result = null;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean done = false;

    @Override
    public void onEvent(R event) {
        this.lock.lock();
        try {
            if (!this.done) {
                this.result = event;
                this.done = true;
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public R get() throws InterruptedException {
        this.lock.lock();
        try {
            if (!this.done) {
                this.condition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.lock.lock();
        try {
            if (!this.done && !this.condition.await(timeout, unit)) {
                throw new TimeoutException();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.result;
    }
}

