/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.joyqueue.toolkit.config.Binder;
import org.joyqueue.toolkit.config.BindingBinder;
import org.joyqueue.toolkit.config.BooleanBinder;
import org.joyqueue.toolkit.config.Context;
import org.joyqueue.toolkit.config.DateBinder;
import org.joyqueue.toolkit.config.DoubleBinder;
import org.joyqueue.toolkit.config.NumberBinder;
import org.joyqueue.toolkit.config.ObjectBinder;
import org.joyqueue.toolkit.config.StringBinder;
import org.joyqueue.toolkit.config.annotation.Binding;
import org.joyqueue.toolkit.config.annotation.BooleanBinding;
import org.joyqueue.toolkit.config.annotation.DateBinding;
import org.joyqueue.toolkit.config.annotation.DoubleBinding;
import org.joyqueue.toolkit.config.annotation.NumberBinding;
import org.joyqueue.toolkit.config.annotation.ObjectBinding;
import org.joyqueue.toolkit.config.annotation.StringBinding;
import org.joyqueue.toolkit.reflect.ReflectException;

public class Binders {
    public static void bind(Context context, Object target) throws ReflectException {
        if (context == null || target == null) {
            return;
        }
        for (Class<?> clazz = target.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Annotation[] annotations = field.getDeclaredAnnotations();
                if (annotations == null) continue;
                for (Annotation annotation : annotations) {
                    Binder binder = Binders.getBinder(annotation);
                    if (binder == null) continue;
                    binder.bind(field, annotation, target, context);
                }
            }
        }
    }

    protected static Binder getBinder(Annotation annotation) {
        Binder binder = null;
        if (annotation instanceof BooleanBinding) {
            binder = BooleanBinder.INSTANCE;
        } else if (annotation instanceof Binding) {
            binder = BindingBinder.INSTANCE;
        } else if (annotation instanceof DateBinding) {
            binder = DateBinder.INSTANCE;
        } else if (annotation instanceof DoubleBinding) {
            binder = DoubleBinder.INSTANCE;
        } else if (annotation instanceof NumberBinding) {
            binder = NumberBinder.INSTANCE;
        } else if (annotation instanceof ObjectBinding) {
            binder = ObjectBinder.INSTANCE;
        } else if (annotation instanceof StringBinding) {
            binder = StringBinder.INSTANCE;
        }
        return binder;
    }
}

