/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.joyqueue.toolkit.config.Binder;
import org.joyqueue.toolkit.config.Context;
import org.joyqueue.toolkit.config.annotation.DateBinding;
import org.joyqueue.toolkit.reflect.Reflect;
import org.joyqueue.toolkit.reflect.ReflectException;

public class DateBinder
implements Binder {
    public static final DateBinder INSTANCE = new DateBinder();

    @Override
    public void bind(Field field, Annotation annotation, Object target, Context context) throws ReflectException {
        if (field == null || annotation == null || target == null || context == null || !(annotation instanceof DateBinding)) {
            return;
        }
        DateBinding binding = (DateBinding)annotation;
        Class<Date> type = field.getType();
        if (type.isAssignableFrom(Date.class)) {
            Object value = context.getObject(binding.key());
            if (value != null && type.isInstance(value)) {
                Reflect.set(field, target, value);
            } else if (value != null && value instanceof Number) {
                Reflect.set(field, target, new Date(((Number)value).longValue()));
            } else {
                String text = binding.defaultValue();
                if (value != null && value instanceof String && (text = (String)value).isEmpty()) {
                    text = binding.defaultValue();
                }
                if (text != null && !text.isEmpty() && binding.format() != null && !binding.format().isEmpty()) {
                    SimpleDateFormat sdf = new SimpleDateFormat(binding.format());
                    try {
                        value = sdf.parse(text);
                        Reflect.set(field, target, value);
                    }
                    catch (ParseException e) {
                        Reflect.set(field, target, null);
                    }
                } else {
                    Reflect.set(field, target, null);
                }
            }
        }
    }
}

