/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.delay;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joyqueue.toolkit.delay.TimerTask;
import org.joyqueue.toolkit.time.SystemClock;

public abstract class DelayedOperation
extends TimerTask {
    private AtomicBoolean completed = new AtomicBoolean(false);
    private AtomicBoolean tryCompletePending = new AtomicBoolean(false);
    private Lock lock;

    public DelayedOperation(long delayMs) {
        this(delayMs, new ReentrantLock());
    }

    public DelayedOperation(long delayMs, Lock lock) {
        this.delayMs = delayMs + SystemClock.now();
        this.lock = lock;
    }

    public boolean forceComplete() {
        if (this.completed.compareAndSet(false, true)) {
            this.cancel();
            this.onComplete();
            return true;
        }
        return false;
    }

    protected boolean isCompleted() {
        return this.completed.get();
    }

    protected abstract void onExpiration();

    protected abstract void onComplete();

    protected abstract boolean tryComplete();

    protected boolean maybeTryComplete() {
        boolean retry = false;
        boolean done = false;
        do {
            if (this.lock.tryLock()) {
                try {
                    this.tryCompletePending.set(false);
                    done = this.tryComplete();
                }
                finally {
                    this.lock.unlock();
                }
                retry = this.tryCompletePending.get();
                continue;
            }
            boolean bl = retry = !this.tryCompletePending.getAndSet(true);
        } while (!this.isCompleted() && retry);
        return done;
    }

    @Override
    public void run() {
        if (this.forceComplete()) {
            this.onExpiration();
        }
    }
}

