/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.delay;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.joyqueue.toolkit.delay.TimerTaskList;

public class TimingWheel {
    private long tickMs;
    private int wheelSize;
    private long startMs;
    private AtomicInteger taskCounter;
    private DelayQueue<TimerTaskList> queue;
    private List<TimerTaskList> buckets = new ArrayList<TimerTaskList>();
    private long interval;
    private long currentTime;
    private volatile TimingWheel overflowWheel = null;

    public TimingWheel(long tickMs, int wheelSize, long startMs, AtomicInteger taskCounter, DelayQueue<TimerTaskList> queue) {
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.startMs = startMs;
        this.taskCounter = taskCounter;
        this.queue = queue;
        this.interval = tickMs * (long)wheelSize;
        this.currentTime = startMs - startMs % tickMs;
        for (int i = 0; i < wheelSize; ++i) {
            this.buckets.add(new TimerTaskList(taskCounter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOverflowWheel() {
        TimingWheel timingWheel = this;
        synchronized (timingWheel) {
            if (this.overflowWheel == null) {
                this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTime, this.taskCounter, this.queue);
            }
        }
    }

    protected boolean add(TimerTaskList.TimerTaskEntry timerTaskEntry) {
        long expiration = timerTaskEntry.timerTask.delayMs;
        if (timerTaskEntry.cancelled()) {
            return false;
        }
        if (expiration < this.currentTime + this.tickMs) {
            return false;
        }
        if (expiration < this.currentTime + this.interval) {
            long virtualId = expiration / this.tickMs;
            TimerTaskList bucket = this.buckets.get((int)(virtualId % (long)this.wheelSize));
            bucket.add(timerTaskEntry);
            if (bucket.setExpiration(virtualId * this.tickMs)) {
                this.queue.offer(bucket);
            }
            return true;
        }
        if (this.overflowWheel == null) {
            this.addOverflowWheel();
        }
        return this.overflowWheel.add(timerTaskEntry);
    }

    protected void advanceClock(long timeMs) {
        if (timeMs >= this.currentTime + this.tickMs) {
            this.currentTime = timeMs - timeMs % this.tickMs;
            if (this.overflowWheel != null) {
                this.overflowWheel.advanceClock(this.currentTime);
            }
        }
    }
}

