/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang3.math.NumberUtils;
import org.joyqueue.toolkit.io.Directory;
import org.joyqueue.toolkit.lang.Close;

public abstract class Files {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copy(FileInputStream in, FileOutputStream out, long start, long length) throws IOException {
        if (in == null || out == null) {
            return;
        }
        FileChannel fci = in.getChannel();
        FileChannel fco = out.getChannel();
        try {
            fci.transferTo(start, length, fco);
            fco.force(false);
        }
        finally {
            Close.close((Closeable)fci);
            Close.close((Closeable)fco);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copy(FileInputStream in, RandomAccessFile out, long start, long length, long position) throws IOException {
        if (in == null || out == null) {
            return;
        }
        out.seek(position);
        FileChannel fci = in.getChannel();
        FileChannel fco = out.getChannel();
        try {
            fci.transferTo(start, length, fco);
            fco.force(false);
        }
        finally {
            Close.close((Closeable)fci);
            Close.close((Closeable)fco);
        }
    }

    protected static void copy(FileChannel in, FileChannel out, long start, long length) throws IOException {
        if (in == null || out == null) {
            return;
        }
        in.transferTo(start, length, out);
        out.force(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target, long start, long length) throws IOException {
        if (source == null || target == null) {
            return;
        }
        if (!target.exists()) {
            target.createNewFile();
        }
        if (length <= 0L) {
            return;
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target, true);
            Files.copy(fis, fos, start < 0L ? 0L : start, length);
        }
        catch (Throwable throwable) {
            Close.close(fis);
            Close.close(fos);
            throw throwable;
        }
        Close.close((Closeable)fis);
        Close.close((Closeable)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target, long start, long length, long position) throws IOException {
        if (source == null || target == null) {
            return;
        }
        if (!target.exists()) {
            target.createNewFile();
        }
        if (length <= 0L) {
            return;
        }
        if (position < 0L || position == target.length()) {
            Files.copy(source, target, start, length);
            return;
        }
        FileInputStream fis = null;
        RandomAccessFile raf = null;
        try {
            fis = new FileInputStream(source);
            raf = new RandomAccessFile(target, "rw");
            Files.copy(fis, raf, start < 0L ? 0L : start, length, position);
        }
        catch (Throwable throwable) {
            Close.close(fis);
            Close.close(raf);
            throw throwable;
        }
        Close.close((Closeable)fis);
        Close.close((Closeable)raf);
    }

    public static void copy(File source, File target, long length) throws IOException {
        Files.copy(source, target, 0L, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target) throws IOException {
        if (source == null || target == null) {
            return;
        }
        if (!target.exists()) {
            target.createNewFile();
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target);
            Files.copy(fis, fos, 0L, source.length());
        }
        catch (Throwable throwable) {
            Close.close(fis);
            Close.close(fos);
            throw throwable;
        }
        Close.close((Closeable)fis);
        Close.close((Closeable)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, File target, long length, long position) throws IOException {
        RandomAccessFile raf;
        FileOutputStream fos;
        block8: {
            if (is == null || target == null) {
                return;
            }
            if (!target.exists()) {
                target.createNewFile();
            }
            if (length <= 0L) {
                return;
            }
            fos = null;
            raf = null;
            try {
                if (is.getClass() == FileInputStream.class) {
                    if (target.length() == position) {
                        fos = new FileOutputStream(target, true);
                        Files.copy((FileInputStream)is, fos, 0L, length);
                    } else {
                        raf = new RandomAccessFile(target, "rw");
                        Files.copy((FileInputStream)is, raf, 0L, length, position);
                    }
                    break block8;
                }
                raf = new RandomAccessFile(target, "rw");
                raf.seek(position);
                Files.copy(is, raf, length);
                raf.getFD().sync();
            }
            catch (Throwable throwable) {
                Close.close(fos);
                Close.close(raf);
                throw throwable;
            }
        }
        Close.close((Closeable)fos);
        Close.close((Closeable)raf);
    }

    public static void copy(InputStream is, OutputStream os, long length) throws IOException {
        Files.copy(is, os, 0L, length);
    }

    public static void copy(InputStream is, OutputStream os, long start, long length) throws IOException {
        if (is == null || os == null || length == 0L) {
            return;
        }
        if (is.getClass() == FileInputStream.class && os.getClass() == FileOutputStream.class) {
            Files.copy((FileInputStream)is, (FileOutputStream)os, start, length);
        } else {
            long bytes = 0L;
            if (start > 0L && (bytes = is.skip(start)) < start) {
                return;
            }
            byte[] buffer = new byte[4096];
            int c = 0;
            for (bytes = 0L; bytes < length && (c = is.read(buffer, 0, (int)Math.min((long)buffer.length, length - bytes))) >= 0; bytes += (long)c) {
                os.write(buffer, 0, c);
            }
        }
    }

    public static void copy(InputStream is, DataOutput os, long length) throws IOException {
        if (is == null || os == null) {
            return;
        }
        byte[] buffer = new byte[4096];
        int c = 0;
        for (long pos = 0L; pos < length && (c = is.read(buffer, 0, (int)Math.min((long)buffer.length, length - pos))) >= 0; pos += (long)c) {
            os.write(buffer, 0, c);
        }
    }

    public static int readBytes(InputStream source, byte[] dest, int offset, int length) throws IOException {
        int lastRead;
        if (source == null || dest == null) {
            return 0;
        }
        int totalRead = lastRead = source.read(dest, offset, length);
        if (lastRead < length) {
            while (totalRead < length && lastRead != -1) {
                lastRead = source.read(dest, offset + totalRead, length - totalRead);
                if (lastRead == -1) continue;
                totalRead += lastRead;
            }
        }
        return totalRead;
    }

    public static int skip(InputStream source, int skip) throws IOException {
        if (source == null || skip <= 0) {
            return 0;
        }
        int toSkip = skip - (int)source.skip(skip);
        boolean more = true;
        while (toSkip > 0 && more) {
            int read = source.read();
            if (read == -1) {
                more = false;
                continue;
            }
            --toSkip;
            toSkip = (int)((long)toSkip - source.skip(toSkip));
        }
        int skipped = skip - toSkip;
        return skipped;
    }

    public static boolean move(File from, File to) throws IOException {
        if (from == null || to == null || !from.exists()) {
            return false;
        }
        to.delete();
        if (!from.renameTo(to)) {
            Files.copy(from, to);
            from.delete();
        }
        return true;
    }

    public static void deleteDirectory(File root) {
        if (root == null || !root.exists()) {
            return;
        }
        if (root.isFile()) {
            root.delete();
        } else if (root.isDirectory()) {
            File[] children = root.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (child.isFile()) {
                        child.delete();
                        continue;
                    }
                    if (!child.isDirectory()) continue;
                    Files.deleteDirectory(child);
                }
            }
            root.delete();
        }
    }

    public static boolean createDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists() && !directory.mkdirs()) {
            return directory.exists();
        }
        return true;
    }

    public static boolean createFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        try {
            if (file.createNewFile()) {
                return true;
            }
            return file.exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void write(File file, String content) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(content);
            writer.newLine();
        }
        catch (Throwable throwable) {
            Close.close(writer);
            throw throwable;
        }
        Close.close((Closeable)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file) throws IOException {
        if (file == null || !file.exists() || file.length() < 1L) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            int count = 0;
            while ((line = reader.readLine()) != null) {
                if (count > 0) {
                    builder.append("\n");
                }
                builder.append(line);
                ++count;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Close.close(reader);
        }
        catch (Throwable throwable) {
            Close.close(reader);
            throw throwable;
        }
        Close.close((Closeable)reader);
        return builder.toString();
    }

    public static String suffix(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).isEmpty()) {
            return null;
        }
        if (name.charAt(0) == '.') {
            if (name.length() == 1) {
                return null;
            }
            name = name.substring(1);
        }
        return name;
    }

    public static File path(String ... files) {
        if (files == null || files.length == 0) {
            return null;
        }
        File result = null;
        for (String file : files) {
            result = result == null ? new File(file) : new File(result, file);
        }
        return result;
    }

    public static void tree(String path, boolean recursive, Directory directory) {
        File file = new File(path);
        if (file.exists()) {
            directory.setName(file.getName());
            directory.setPath(path);
            directory.setDirectory(file.isDirectory());
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files.length > 0) {
                    directory.setChildren(new ArrayList<Directory>());
                }
                if (recursive) {
                    Files.sortByName(files);
                    for (File f : files) {
                        Directory child = new Directory();
                        if (f.isDirectory()) {
                            Files.tree(f.getPath(), true, child);
                        } else {
                            child.setName(f.getName());
                            child.setPath(f.getPath());
                        }
                        directory.getChildren().add(child);
                    }
                }
            }
        }
    }

    public static void sortByName(File[] files) {
        boolean allNumbers = true;
        for (File file : files) {
            if (NumberUtils.isNumber((String)file.getName())) continue;
            allNumbers = false;
            break;
        }
        if (allNumbers) {
            Arrays.sort(files, (a, b) -> (int)(Long.valueOf(a.getName()) - Long.valueOf(b.getName())));
        } else {
            Arrays.sort(files, Comparator.comparing(File::getName));
        }
    }
}

