/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.retry;

import java.util.concurrent.Callable;
import org.joyqueue.toolkit.exception.Abnormity;
import org.joyqueue.toolkit.lang.Online;
import org.joyqueue.toolkit.retry.RetryPolicy;
import org.joyqueue.toolkit.time.SystemClock;

public abstract class Retry {
    public static <T> T execute(RetryPolicy policy, Callable<T> executor) throws Exception {
        if (executor == null) {
            throw new IllegalArgumentException("executor can not be null");
        }
        if (policy == null) {
            throw new IllegalArgumentException("policy can not be null");
        }
        int retryCount = 0;
        long startTime = SystemClock.now();
        boolean loop = true;
        Exception error = null;
        while (loop) {
            try {
                return executor.call();
            }
            catch (Exception e) {
                error = e;
                if (executor instanceof Abnormity) {
                    loop = ((Abnormity)((Object)executor)).onException(e);
                }
                if (loop && executor instanceof Online) {
                    loop = ((Online)((Object)executor)).isStarted();
                }
                if (!loop) continue;
                long now = SystemClock.now();
                long time = policy.getTime(now, ++retryCount, startTime);
                if (time <= 0L) {
                    throw e;
                }
                Thread.sleep(time - now);
                if (!(executor instanceof Online)) continue;
                loop = ((Online)((Object)executor)).isStarted();
            }
        }
        throw error;
    }
}

