/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.retry;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;

public class RetryPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int EXPIRE_TIME = 259200000;
    public static final int RETRY_DELAY = 1000;
    public static final int MAX_RETRY_DELAY = 0;
    public static final double BACKOFF_MULTIPLIER = 2.0;
    public static final int MAX_RETRYS = 0;
    private volatile AtomicReference<Integer> maxExponential = new AtomicReference();
    private Integer maxRetrys;
    private Integer maxRetryDelay;
    private Integer retryDelay;
    private Boolean useExponentialBackOff;
    private Double backOffMultiplier;
    private Integer expireTime;

    public RetryPolicy() {
    }

    public RetryPolicy(Integer retryDelay, Integer maxRetrys) {
        this.setRetryDelay(retryDelay);
        this.setMaxRetryDelay(retryDelay);
        this.setMaxRetrys(maxRetrys);
    }

    public RetryPolicy(Integer retryDelay, Integer maxRetryDelay, Integer maxRetrys, Boolean useExponentialBackOff, Double backOffMultiplier, Integer expireTime) {
        this.setRetryDelay(retryDelay);
        this.setMaxRetryDelay(maxRetryDelay);
        this.setMaxRetrys(maxRetrys);
        this.setUseExponentialBackOff(useExponentialBackOff);
        this.setBackOffMultiplier(backOffMultiplier);
        this.setExpireTime(expireTime);
    }

    public long getTime(long now, int retryTimes, long startTime) {
        int expireTime;
        long time = 0L;
        int retrys = retryTimes < 1 ? 1 : retryTimes;
        int maxRetrys = this.maxRetrys == null ? 0 : this.maxRetrys;
        int retryDelay = this.retryDelay == null ? 1000 : this.retryDelay;
        int maxRetryDelay = this.maxRetryDelay == null ? 0 : this.maxRetryDelay;
        boolean useExponentialBackOff = this.useExponentialBackOff == null ? true : this.useExponentialBackOff;
        double backOffMultiplier = this.backOffMultiplier == null || this.backOffMultiplier < 1.0 ? 2.0 : this.backOffMultiplier;
        int n = expireTime = this.expireTime == null ? 259200000 : this.expireTime;
        if (maxRetrys > 0 && retrys > maxRetrys) {
            time = 0L;
        } else if (retryDelay <= 0) {
            time = now;
        } else {
            long delay = 0L;
            if (useExponentialBackOff) {
                int exponential = retrys - 1;
                if (backOffMultiplier == 1.0) {
                    delay = retryDelay;
                } else if (maxRetryDelay > 0) {
                    Integer maxExp = this.maxExponential.get();
                    if (maxExp == null && !this.maxExponential.compareAndSet(null, maxExp = Integer.valueOf((int)(Math.log(maxRetryDelay) / Math.log(backOffMultiplier))))) {
                        maxExp = this.maxExponential.get();
                    }
                    delay = exponential >= maxExp ? (long)maxRetryDelay : Math.round((double)retryDelay * Math.pow(backOffMultiplier, exponential));
                } else {
                    delay = Math.round((double)retryDelay * Math.pow(backOffMultiplier, exponential));
                }
            } else {
                delay = retryDelay;
            }
            time = delay <= 0L ? now : (maxRetryDelay > 0 && delay >= (long)maxRetryDelay ? now + (long)maxRetryDelay : now + delay);
        }
        if (expireTime > 0 && time > 0L && time >= startTime + (long)expireTime) {
            time = 0L;
        }
        return time;
    }

    public Integer getMaxRetrys() {
        return this.maxRetrys;
    }

    public void setMaxRetrys(Integer maxRetrys) {
        this.maxRetrys = maxRetrys;
    }

    public Integer getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public void setMaxRetryDelay(Integer maxRetryDelay) {
        this.maxRetryDelay = maxRetryDelay;
        this.maxExponential.set(null);
    }

    public Integer getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(Integer retryDelay) {
        this.retryDelay = retryDelay;
        this.maxExponential.set(null);
    }

    public Boolean getUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(Boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public Double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(Double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
        this.maxExponential.set(null);
    }

    public Integer getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryPolicy that = (RetryPolicy)o;
        if (this.backOffMultiplier != null ? !this.backOffMultiplier.equals(that.backOffMultiplier) : that.backOffMultiplier != null) {
            return false;
        }
        if (this.expireTime != null ? !this.expireTime.equals(that.expireTime) : that.expireTime != null) {
            return false;
        }
        if (this.maxRetryDelay != null ? !this.maxRetryDelay.equals(that.maxRetryDelay) : that.maxRetryDelay != null) {
            return false;
        }
        if (this.maxRetrys != null ? !this.maxRetrys.equals(that.maxRetrys) : that.maxRetrys != null) {
            return false;
        }
        if (this.retryDelay != null ? !this.retryDelay.equals(that.retryDelay) : that.retryDelay != null) {
            return false;
        }
        return this.useExponentialBackOff != null ? this.useExponentialBackOff.equals(that.useExponentialBackOff) : that.useExponentialBackOff == null;
    }

    public int hashCode() {
        int result = this.maxRetrys != null ? this.maxRetrys.hashCode() : 0;
        result = 31 * result + (this.maxRetryDelay != null ? this.maxRetryDelay.hashCode() : 0);
        result = 31 * result + (this.retryDelay != null ? this.retryDelay.hashCode() : 0);
        result = 31 * result + (this.useExponentialBackOff != null ? this.useExponentialBackOff.hashCode() : 0);
        result = 31 * result + (this.backOffMultiplier != null ? this.backOffMultiplier.hashCode() : 0);
        result = 31 * result + (this.expireTime != null ? this.expireTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RetryPolicy{");
        sb.append("maxRetrys=").append(this.maxRetrys);
        sb.append(", maxRetryDelay=").append(this.maxRetryDelay);
        sb.append(", retryDelay=").append(this.retryDelay);
        sb.append(", useExponentialBackOff=").append(this.useExponentialBackOff);
        sb.append(", backOffMultiplier=").append(this.backOffMultiplier);
        sb.append(", expireTime=").append(this.expireTime);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private Integer maxRetrys;
        private Integer maxRetryDelay;
        private Integer retryDelay;
        private Boolean useExponentialBackOff;
        private Double backOffMultiplier;
        private Integer expireTime;

        public static Builder build() {
            return new Builder();
        }

        public Builder maxRetrys(Integer maxRetrys) {
            this.maxRetrys = maxRetrys;
            return this;
        }

        public Builder maxRetryDelay(Integer maxRetryDelay) {
            this.maxRetryDelay = maxRetryDelay;
            return this;
        }

        public Builder retryDelay(Integer retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public Builder useExponentialBackOff(Boolean useExponentialBackOff) {
            this.useExponentialBackOff = useExponentialBackOff;
            return this;
        }

        public Builder backOffMultiplier(Double backOffMultiplier) {
            this.backOffMultiplier = backOffMultiplier;
            return this;
        }

        public Builder expireTime(Integer expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public RetryPolicy create() {
            return new RetryPolicy(this.retryDelay, this.maxRetryDelay, this.maxRetrys, this.useExponentialBackOff, this.backOffMultiplier, this.expireTime);
        }
    }
}

