/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.security;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import org.joyqueue.toolkit.security.Decryptor;
import org.joyqueue.toolkit.security.Encryptor;
import org.joyqueue.toolkit.security.Hex;

public class Encrypt {
    public static final String DEFAULT_KEY = "www.jd.com";

    public static String encrypt(String source, String key, Encryptor encryptor) throws GeneralSecurityException {
        return Encrypt.encrypt(source, key, encryptor, Charsets.UTF_8);
    }

    public static String encrypt(String source, String key, Encryptor encryptor, Charset charset) throws GeneralSecurityException {
        byte[] sources;
        if (source == null) {
            return "";
        }
        if (encryptor == null) {
            return source;
        }
        byte[] keys = null;
        if (charset == null) {
            sources = source.getBytes();
            if (key != null) {
                keys = key.getBytes();
            }
        } else {
            sources = source.getBytes(charset);
            if (key != null) {
                keys = key.getBytes(charset);
            }
        }
        return Hex.encode(encryptor.encrypt(sources, keys));
    }

    public static String decrypt(String source, String key, Decryptor decryptor) throws GeneralSecurityException {
        return Encrypt.decrypt(source, key, decryptor, Charsets.UTF_8);
    }

    public static String decrypt(String source, String key, Decryptor decryptor, Charset charset) throws GeneralSecurityException {
        if (source == null) {
            return "";
        }
        if (decryptor == null) {
            return source;
        }
        byte[] keys = null;
        if (charset == null) {
            byte[] sources = Hex.decode(source);
            if (key != null) {
                keys = key.getBytes();
            }
            return new String(decryptor.decrypt(sources, keys));
        }
        byte[] sources = Hex.decode(source);
        if (key != null) {
            keys = key.getBytes(charset);
        }
        return new String(decryptor.decrypt(sources, keys), charset);
    }
}

