/*
 * ===========================================
 * Java Pdf Extraction Decoding Access Library
 * ===========================================
 *
 * Project Info:  http://www.idrsolutions.com
 * Help section for developers at http://www.idrsolutions.com/support/
 *
 * (C) Copyright 1997-2017 IDRsolutions and Contributors.
 *
 * This file is part of JPedal/JPDF2HTML5
 *
     This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


 *
 * ---------------
 * T3Glyphs.java
 * ---------------
 */
package org.jpedal.fonts.glyph;

public class T3Glyphs extends PdfJavaGlyphs {

	/**holds lookup to type 3 charProcs*/
	private final PdfGlyph[] charProcs = new PdfGlyph[256];

	/**
	 * template used by t1/tt fonts
	 */
	@Override
    public PdfGlyph getEmbeddedGlyph(final GlyphFactory factory, final String glyph, final float[][] Trm, final int rawInt, final String displayValue, final float currentWidth, final String key) {

		/*flush cache if needed*/
		if((lastTrm[0][0]!=Trm[0][0])|(lastTrm[1][0]!=Trm[1][0])|
				(lastTrm[0][1]!=Trm[0][1])|(lastTrm[1][1]!=Trm[1][1])){
			lastTrm=Trm;
			flush();
		}

		//either calculate the glyph to draw or reuse if alreasy drawn
		PdfGlyph transformedGlyph2 = getEmbeddedCachedShape(rawInt);

		if (transformedGlyph2 == null) {

			//shape to draw onto
			transformedGlyph2=charProcs[rawInt];

			//save so we can reuse if it occurs again in this TJ command
			setEmbeddedCachedShape(rawInt, transformedGlyph2);

		}

		return transformedGlyph2;
	}

   // make key Integer and don't lookup Glyph on T3 and make charProcs an array with int key
    @Override
    public void setT3Glyph(final int key, final int altKey, final PdfGlyph glyph) {

       charProcs[key]=glyph;
       
       if(altKey!=-1 && charProcs[altKey]==null) {
           charProcs[altKey] = glyph;
       }

       //debug code
//       BufferedImage img=new BufferedImage(40, 40, BufferedImage.TYPE_INT_ARGB);
//       Graphics2D g2=img.createGraphics();
//       g2.setPaint(Color.GREEN);
//       g2.fillRect(0,0,img.getWidth(),img.getHeight());
//       glyph.render(0,g2,1);
//
//       if(key==49)
//       ShowGUIMessage.showGUIMessage("x",img,"x");

	}
}
